/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.kafka.services.ContainerLocalKafkaService;
import org.apache.camel.test.infra.kafka.services.KafkaService;
import org.apache.camel.test.infra.kafka.services.RedpandaService;
import org.apache.camel.test.infra.kafka.services.RemoteKafkaService;
import org.apache.camel.test.infra.kafka.services.StrimziService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class KafkaServiceFactory {
    private static SimpleTestServiceBuilder<KafkaService> instance;
    private static KafkaService kafkaService;

    private KafkaServiceFactory() {
    }

    public static SimpleTestServiceBuilder<KafkaService> builder() {
        return new SimpleTestServiceBuilder("kafka");
    }

    public static KafkaService createService() {
        SimpleTestServiceBuilder builder = new SimpleTestServiceBuilder("kafka");
        return (KafkaService)builder.addLocalMapping(ContainerLocalKafkaService::kafka3Container).addMapping("local-strimzi-container", StrimziService::new).addRemoteMapping(RemoteKafkaService::new).addMapping("local-kafka3-container", ContainerLocalKafkaService::kafka3Container).addMapping("local-kafka2-container", ContainerLocalKafkaService::new).addMapping("local-redpanda-container", RedpandaService::new).build();
    }

    public static synchronized KafkaService createSingletonService() {
        if (kafkaService == null) {
            if (instance == null) {
                instance = KafkaServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonKafkaService(ContainerLocalKafkaService.kafka3Container(), "kafka")).addRemoteMapping(RemoteKafkaService::new).addMapping("local-kafka3-container", () -> new SingletonKafkaService(ContainerLocalKafkaService.kafka3Container(), "kafka3")).addMapping("local-kafka2-container", () -> new SingletonKafkaService(new ContainerLocalKafkaService(), "kafka2")).addMapping("local-strimzi-container", () -> new SingletonKafkaService(new StrimziService(), "strimzi")).addMapping("local-redpanda-container", () -> new SingletonKafkaService(new RedpandaService(), "redpanda"));
            }
            kafkaService = (KafkaService)instance.build();
        }
        return kafkaService;
    }

    static class SingletonKafkaService
    extends SingletonService<KafkaService>
    implements KafkaService {
        public SingletonKafkaService(KafkaService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String getBootstrapServers() {
            return ((KafkaService)this.getService()).getBootstrapServers();
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }
    }
}

