/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.test.infra.common.services.TestService;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface KafkaService
extends TestService,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public String getBootstrapServers();

    default public void beforeAll(ExtensionContext extensionContext) {
        try {
            this.initialize();
        }
        catch (Exception e) {
            Logger log = LoggerFactory.getLogger(KafkaService.class);
            Object o = extensionContext.getTestInstance().get();
            log.error("Failed to initialize service {} for test {} on ({})", new Object[]{this.getClass().getSimpleName(), extensionContext.getDisplayName(), o.getClass().getName()});
            throw e;
        }
    }

    default public void beforeTestExecution(ExtensionContext extensionContext) {
    }

    default public void afterAll(ExtensionContext extensionContext) {
        this.shutdown();
    }

    default public void afterTestExecution(ExtensionContext context) {
    }
}

