/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.kafka.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.kafka.services.ContainerLocalKafkaService;
import org.apache.camel.test.infra.kafka.services.KafkaService;
import org.apache.camel.test.infra.kafka.services.RedpandaService;
import org.apache.camel.test.infra.kafka.services.RemoteKafkaService;
import org.apache.camel.test.infra.kafka.services.StrimziService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class KafkaServiceFactory {
    private KafkaServiceFactory() {
    }

    public static SimpleTestServiceBuilder<KafkaService> builder() {
        return new SimpleTestServiceBuilder("kafka");
    }

    public static KafkaService createService() {
        SimpleTestServiceBuilder builder = new SimpleTestServiceBuilder("kafka");
        return (KafkaService)builder.addLocalMapping(ContainerLocalKafkaService::kafka3Container).addMapping("local-strimzi-container", StrimziService::new).addRemoteMapping(RemoteKafkaService::new).addMapping("local-kafka3-container", ContainerLocalKafkaService::kafka3Container).addMapping("local-kafka2-container", ContainerLocalKafkaService::kafka2Container).addMapping("local-redpanda-container", RedpandaService::new).build();
    }

    public static KafkaService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final KafkaService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<KafkaService> instance = KafkaServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonKafkaService(ContainerLocalKafkaService.kafka3Container(), "kafka")).addRemoteMapping(RemoteKafkaService::new).addMapping("local-kafka3-container", () -> new SingletonKafkaService(ContainerLocalKafkaService.kafka3Container(), "kafka3")).addMapping("local-kafka2-container", () -> new SingletonKafkaService(ContainerLocalKafkaService.kafka2Container(), "kafka2")).addMapping("local-strimzi-container", () -> new SingletonKafkaService(new StrimziService(), "strimzi")).addMapping("local-redpanda-container", () -> new SingletonKafkaService(new RedpandaService(), "redpanda"));
            INSTANCE = (KafkaService)instance.build();
        }
    }

    static class SingletonKafkaService
    extends SingletonService<KafkaService>
    implements KafkaService {
        public SingletonKafkaService(KafkaService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String getBootstrapServers() {
            return ((KafkaService)this.getService()).getBootstrapServers();
        }

        @Override
        public final void beforeAll(ExtensionContext extensionContext) {
            super.beforeAll(extensionContext);
        }

        @Override
        public final void afterAll(ExtensionContext extensionContext) {
        }
    }
}

