/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.messaging.services;

import java.util.function.Function;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.messaging.services.MessagingInfraService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class MessagingLocalContainerInfraService<T extends GenericContainer<T>>
implements MessagingInfraService,
ContainerService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MessagingLocalContainerInfraService.class);
    private final T container;
    private final Function<T, String> endpointFunction;

    public MessagingLocalContainerInfraService(T container, Function<T, String> endpointFunction) {
        this.container = container;
        this.endpointFunction = endpointFunction;
    }

    public T getContainer() {
        return this.container;
    }

    @Override
    public String defaultEndpoint() {
        return this.endpointFunction.apply(this.container);
    }

    public void registerProperties() {
        System.setProperty("messaging.broker.address", this.defaultEndpoint());
    }

    public void initialize() {
        LOG.info("Trying to start the message broker container");
        this.container.start();
        this.registerProperties();
        LOG.info("Message broker running at address {}", (Object)this.defaultEndpoint());
    }

    public void shutdown() {
        LOG.info("Stopping message broker container");
        this.container.stop();
    }
}

