/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.messaging.services;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.test.infra.messaging.services.MessagingLocalContainerService;
import org.apache.camel.test.infra.messaging.services.MessagingRemoteService;
import org.apache.camel.test.infra.messaging.services.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

@Deprecated
public class MessagingServiceBuilder<T extends GenericContainer<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(MessagingServiceBuilder.class);
    private Supplier<T> containerSupplier;
    private Function<T, String> endpointFunction;

    protected MessagingServiceBuilder() {
    }

    public static <T extends GenericContainer<T>> MessagingServiceBuilder<T> newBuilder(Supplier<T> containerSupplier) {
        MessagingServiceBuilder<T> messagingServiceBuilder = new MessagingServiceBuilder<T>();
        messagingServiceBuilder.withContainer(containerSupplier);
        return messagingServiceBuilder;
    }

    protected MessagingServiceBuilder<T> withContainer(Supplier<T> containerSupplier) {
        this.containerSupplier = containerSupplier;
        return this;
    }

    public MessagingServiceBuilder<T> withEndpointProvider(Function<T, String> endpointFunction) {
        this.endpointFunction = endpointFunction;
        return this;
    }

    public MessagingService build() {
        String instanceType = System.getProperty("messaging.instance.type");
        if (instanceType == null || instanceType.isEmpty()) {
            LOG.info("Creating a new messaging local container service");
            return new MessagingLocalContainerService<GenericContainer>((GenericContainer)this.containerSupplier.get(), this.endpointFunction);
        }
        if (instanceType.equals("remote")) {
            return new MessagingRemoteService();
        }
        throw new UnsupportedOperationException("Invalid messaging instance type");
    }
}

