/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.mongodb.services;

import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.mongodb.services.MongoDBLocalContainerService;
import org.apache.camel.test.infra.mongodb.services.MongoDBRemoteService;
import org.apache.camel.test.infra.mongodb.services.MongoDBService;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class MongoDBServiceFactory {
    private static SimpleTestServiceBuilder<MongoDBService> instance;
    private static MongoDBService service;

    private MongoDBServiceFactory() {
    }

    public static SimpleTestServiceBuilder<MongoDBService> builder() {
        return new SimpleTestServiceBuilder("mongodb");
    }

    public static MongoDBService createService() {
        return (MongoDBService)MongoDBServiceFactory.builder().addLocalMapping(MongoDBLocalContainerService::new).addRemoteMapping(MongoDBRemoteService::new).build();
    }

    public static MongoDBService createSingletonService() {
        if (service == null) {
            if (instance == null) {
                instance = MongoDBServiceFactory.builder();
                instance.addLocalMapping(() -> new SingletonMongoDBService(new MongoDBLocalContainerService(), "mongo-db")).addRemoteMapping(MongoDBRemoteService::new);
            }
            service = (MongoDBService)instance.build();
        }
        return service;
    }

    static class SingletonMongoDBService
    extends SingletonService<MongoDBService>
    implements MongoDBService {
        public SingletonMongoDBService(MongoDBService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public void beforeAll(ExtensionContext extensionContext) {
            this.addToStore(extensionContext);
        }

        @Override
        public void afterAll(ExtensionContext extensionContext) {
        }

        @Override
        public String getReplicaSetUrl() {
            return ((MongoDBService)this.getService()).getReplicaSetUrl();
        }

        @Override
        public String getConnectionAddress() {
            return ((MongoDBService)this.getService()).getConnectionAddress();
        }
    }
}

