/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ToolCallDefinition {
    private final String name;
    private final Map<String, Object> arguments;

    public ToolCallDefinition(String name) {
        this.name = Objects.requireNonNull(name, "Tool name cannot be null");
        this.arguments = new HashMap<String, Object>();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getArguments() {
        return new HashMap<String, Object>(this.arguments);
    }

    public void addArgument(String key, Object value) {
        this.arguments.put(key, value);
    }

    public String toString() {
        return String.format("ToolCall{name='%s', arguments=%s}", this.name, this.arguments);
    }
}

