/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.openai.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.camel.test.infra.openai.mock.ToolCallDefinition;

public class ToolExecutionStep {
    private final List<ToolCallDefinition> toolCalls = new ArrayList<ToolCallDefinition>();

    public void addToolCall(ToolCallDefinition toolCall) {
        this.toolCalls.add(Objects.requireNonNull(toolCall, "Tool call cannot be null"));
    }

    public List<ToolCallDefinition> getToolCalls() {
        return new ArrayList<ToolCallDefinition>(this.toolCalls);
    }

    public boolean isEmpty() {
        return this.toolCalls.isEmpty();
    }

    public int size() {
        return this.toolCalls.size();
    }

    public ToolCallDefinition getLastToolCall() {
        if (this.toolCalls.isEmpty()) {
            throw new IllegalStateException("No tool calls in this step");
        }
        return this.toolCalls.get(this.toolCalls.size() - 1);
    }

    public String toString() {
        return String.format("ToolExecutionStep{toolCalls=%s}", this.toolCalls);
    }
}

