/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.pulsar.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.pulsar.services.PulsarService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.PulsarContainer;
import org.testcontainers.utility.DockerImageName;

public class PulsarLocalContainerService
implements PulsarService,
ContainerService<PulsarContainer> {
    public static final String CONTAINER_IMAGE = "apachepulsar/pulsar:2.10.2";
    private static final Logger LOG = LoggerFactory.getLogger(PulsarLocalContainerService.class);
    private final PulsarContainer container;

    public PulsarLocalContainerService() {
        this(System.getProperty("pulsar.container", CONTAINER_IMAGE));
    }

    public PulsarLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName);
    }

    public PulsarLocalContainerService(PulsarContainer container) {
        this.container = container;
    }

    protected PulsarContainer initContainer(String imageName) {
        return new PulsarContainer(DockerImageName.parse((String)imageName));
    }

    public void registerProperties() {
        System.setProperty("pulsar.admin.url", this.getPulsarAdminUrl());
        System.setProperty("pulsar.broker.url", this.getPulsarBrokerUrl());
    }

    public void initialize() {
        LOG.info("Trying to start the Pulsar container");
        this.container.start();
        this.registerProperties();
        LOG.info("Pulsar instance running at {}", (Object)this.getPulsarAdminUrl());
        LOG.info("Pulsar admin URL available at {}", (Object)this.getPulsarAdminUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Pulsar container");
        this.container.stop();
    }

    public PulsarContainer getContainer() {
        return this.container;
    }

    @Override
    public String getPulsarAdminUrl() {
        return this.container.getHttpServiceUrl();
    }

    @Override
    public String getPulsarBrokerUrl() {
        return this.container.getPulsarBrokerUrl();
    }
}

