/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.qdrant.services;

import java.net.http.HttpResponse;
import java.util.Map;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.qdrant.services.QdrantLocalContainerService;
import org.apache.camel.test.infra.qdrant.services.QdrantRemoteService;
import org.apache.camel.test.infra.qdrant.services.QdrantService;

public final class QdrantServiceFactory {
    private QdrantServiceFactory() {
    }

    public static SimpleTestServiceBuilder<QdrantService> builder() {
        return new SimpleTestServiceBuilder("qdrant");
    }

    public static QdrantService createService() {
        return (QdrantService)QdrantServiceFactory.builder().addLocalMapping(QdrantLocalContainerService::new).addRemoteMapping(QdrantRemoteService::new).build();
    }

    public static QdrantService createSingletonService() {
        return (QdrantService)QdrantServiceFactory.builder().addLocalMapping(() -> new SingletonQdrantService(new QdrantLocalContainerService(), "qdrant")).build();
    }

    public static class SingletonQdrantService
    extends SingletonService<QdrantService>
    implements QdrantService {
        public SingletonQdrantService(QdrantService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String getHttpHost() {
            return ((QdrantService)this.getService()).getHttpHost();
        }

        @Override
        public int getHttpPort() {
            return ((QdrantService)this.getService()).getHttpPort();
        }

        @Override
        public String getGrpcHost() {
            return ((QdrantService)this.getService()).getGrpcHost();
        }

        @Override
        public int getGrpcPort() {
            return ((QdrantService)this.getService()).getGrpcPort();
        }

        @Override
        public HttpResponse<byte[]> put(String path, Map<Object, Object> body) throws Exception {
            return ((QdrantService)this.getService()).put(path, body);
        }
    }
}

