/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.rocketmq.services;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.test.infra.common.LocalPropertyResolver;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.rocketmq.services.RocketMQBrokerContainer;
import org.apache.camel.test.infra.rocketmq.services.RocketMQNameserverContainer;
import org.apache.camel.test.infra.rocketmq.services.RocketMQService;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.Network;

public class RocketMQContainer
implements RocketMQService,
ContainerService<RocketMQNameserverContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(RocketMQContainer.class);
    public static final String ROCKETMQ_VERSION = LocalPropertyResolver.getProperty(RocketMQContainer.class, (String)"itest.rocketmq.container.image.version");
    public static final String ROCKETMQ_IMAGE = LocalPropertyResolver.getProperty(RocketMQContainer.class, (String)"itest.rocketmq.container.image") + ":" + ROCKETMQ_VERSION;
    private final RocketMQNameserverContainer nameserverContainer;
    private final RocketMQBrokerContainer brokerContainer1;

    public RocketMQContainer() {
        Network network = Network.newNetwork();
        this.nameserverContainer = new RocketMQNameserverContainer(network);
        this.brokerContainer1 = new RocketMQBrokerContainer(network, "broker1");
    }

    public RocketMQNameserverContainer getContainer() {
        return this.nameserverContainer;
    }

    public void registerProperties() {
    }

    public void initialize() {
        this.nameserverContainer.start();
        LOG.info("Apache RocketMQ running at address {}", (Object)this.nameserverAddress());
        this.brokerContainer1.start();
    }

    public void shutdown() {
        this.nameserverContainer.stop();
        this.brokerContainer1.stop();
    }

    @Override
    public void createTopic(String topic) {
        Awaitility.await().atMost(20L, TimeUnit.SECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> {
            Container.ExecResult execResult = this.brokerContainer1.execInContainer(new String[]{"sh", "mqadmin", "updateTopic", "-n", "nameserver:9876", "-t", topic, "-c", "DefaultCluster"});
            LOG.info("Exit code: {}. Stderr: {} Stdout: {} ", new Object[]{execResult.getExitCode(), execResult.getStderr(), execResult.getStdout()});
            return execResult.getStdout() != null && execResult.getStdout().contains("success");
        });
    }

    @Override
    public void deleteTopic(String topic) throws IOException, InterruptedException {
        this.brokerContainer1.execInContainer(new String[]{"sh", "mqadmin", "deleteTopic", "-n", "nameserver:9876", "-t", topic});
    }

    @Override
    public String nameserverAddress() {
        return this.nameserverContainer.getHost() + ":" + this.nameserverContainer.getMappedPort(9876);
    }
}

