/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.rocketmq.services;

import java.io.IOException;
import org.apache.camel.test.infra.common.services.SimpleTestServiceBuilder;
import org.apache.camel.test.infra.common.services.SingletonService;
import org.apache.camel.test.infra.common.services.TestService;
import org.apache.camel.test.infra.rocketmq.services.RocketMQContainerService;
import org.apache.camel.test.infra.rocketmq.services.RocketMQService;

public final class RocketMQServiceFactory {
    private RocketMQServiceFactory() {
    }

    public static SimpleTestServiceBuilder<RocketMQService> builder() {
        return new SimpleTestServiceBuilder("rocketmq");
    }

    public static RocketMQService createService() {
        return (RocketMQService)RocketMQServiceFactory.builder().addLocalMapping(RocketMQContainerService::new).build();
    }

    public static RocketMQService createSingletonService() {
        return SingletonServiceHolder.INSTANCE;
    }

    private static class SingletonServiceHolder {
        static final RocketMQService INSTANCE;

        private SingletonServiceHolder() {
        }

        static {
            SimpleTestServiceBuilder<RocketMQService> instance = RocketMQServiceFactory.builder();
            instance.addLocalMapping(() -> new SingletonKRocketMQService(new RocketMQContainerService(), "rocketmq"));
            INSTANCE = (RocketMQService)instance.build();
        }
    }

    static class SingletonKRocketMQService
    extends SingletonService<RocketMQService>
    implements RocketMQService {
        public SingletonKRocketMQService(RocketMQService service, String name) {
            super((TestService)service, name);
        }

        @Override
        public String nameserverAddress() {
            return ((RocketMQService)this.getService()).nameserverAddress();
        }

        @Override
        public void createTopic(String topic) {
            ((RocketMQService)this.getService()).createTopic(topic);
        }

        @Override
        public void deleteTopic(String topic) throws IOException, InterruptedException {
            ((RocketMQService)this.getService()).deleteTopic(topic);
        }
    }
}

