/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.rocketmq.services;

import java.util.Collections;
import org.apache.camel.test.infra.rocketmq.services.RocketMQContainerService;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class RocketMQBrokerContainer
extends GenericContainer<RocketMQBrokerContainer> {
    public RocketMQBrokerContainer(Network network, String confName) {
        super(RocketMQContainerService.ROCKETMQ_IMAGE);
        this.withNetwork(network);
        this.withExposedPorts(new Integer[]{10912, 10911, 10909});
        this.withEnv("NAMESRV_ADDR", "nameserver:9876");
        this.withClasspathResourceMapping(confName + "/" + confName + ".conf", "/opt/rocketmq-" + RocketMQContainerService.ROCKETMQ_VERSION + "/conf/broker.conf", BindMode.READ_WRITE);
        this.withTmpFs(Collections.singletonMap("/home/rocketmq/store", "rw"));
        this.withTmpFs(Collections.singletonMap("/home/rocketmq/logs", "rw"));
        this.withCommand(new String[]{"sh", "mqbroker", "-c", "/opt/rocketmq-" + RocketMQContainerService.ROCKETMQ_VERSION + "/conf/broker.conf"});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
        this.withCreateContainerCmdModifier(cmd -> cmd.withName(confName));
    }
}

