/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.solr.services;

import java.util.function.Consumer;
import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.solr.services.SolrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class SolrLocalContainerService
implements SolrService,
ContainerService<GenericContainer> {
    public static final String CONTAINER_IMAGE = "solr:8.8.2";
    public static final String CONTAINER_NAME = "solr";
    private static final int PORT = 8983;
    private static final Logger LOG = LoggerFactory.getLogger(SolrLocalContainerService.class);
    private final GenericContainer container;

    public SolrLocalContainerService() {
        this(System.getProperty("solr.container", CONTAINER_IMAGE));
    }

    public SolrLocalContainerService(String imageName) {
        this.container = this.initContainer(imageName, CONTAINER_NAME);
    }

    protected GenericContainer initContainer(String imageName, String containerName) {
        return new GenericContainer(imageName).withNetworkAliases(new String[]{containerName}).withExposedPorts(new Integer[]{8983}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG).withPrefix(CONTAINER_IMAGE)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Server.*Started.*", (int)1)).withCommand(this.isCloudMode() ? "-c" : "");
    }

    public void registerProperties() {
        System.setProperty("solr.service.address", this.getSolrBaseUrl());
    }

    public void initialize() {
        LOG.info("Trying to start the {} container", (Object)CONTAINER_IMAGE);
        this.container.start();
        this.registerProperties();
        LOG.info("{} instance running at {}", (Object)CONTAINER_IMAGE, (Object)this.getSolrBaseUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the {} container", (Object)CONTAINER_IMAGE);
        this.container.stop();
    }

    public GenericContainer getContainer() {
        return this.container;
    }

    protected String getHost() {
        return this.container.getHost();
    }

    protected int getPort() {
        return this.container.getMappedPort(8983);
    }

    @Override
    public String getSolrBaseUrl() {
        return String.format("http://%s:%d/solr", this.getHost(), this.getPort());
    }

    @Override
    public boolean isCloudMode() {
        return false;
    }
}

