/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.infra.solr.services;

import org.apache.camel.test.infra.common.services.ContainerService;
import org.apache.camel.test.infra.solr.services.SolrContainer;
import org.apache.camel.test.infra.solr.services.SolrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrLocalContainerService
implements SolrService,
ContainerService<SolrContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(SolrLocalContainerService.class);
    private final SolrContainer container = SolrContainer.initContainer("solr", this.isCloudMode());

    public void registerProperties() {
        System.setProperty("solr.service.address", this.getSolrBaseUrl());
    }

    public void initialize() {
        LOG.info("Trying to start solr container");
        this.container.withStartupAttempts(5);
        this.container.start();
        this.registerProperties();
        LOG.info("Solr instance running at {}", (Object)this.getSolrBaseUrl());
    }

    public void shutdown() {
        LOG.info("Stopping the Solr container");
        this.container.stop();
    }

    public SolrContainer getContainer() {
        return this.container;
    }

    protected String getHost() {
        return this.container.getHost();
    }

    protected int getPort() {
        return this.container.getMappedPort(8983);
    }

    @Override
    public String getSolrBaseUrl() {
        return String.format("http://%s:%d/solr", this.getHost(), this.getPort());
    }

    @Override
    public boolean isCloudMode() {
        return false;
    }
}

