/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.Message;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.InterceptSendToMockEndpointStrategy;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.BreakpointSupport;
import org.apache.camel.test.CamelRouteCoverageDumper;
import org.apache.camel.test.junit5.TestSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CamelTestSupport
implements BeforeEachCallback,
AfterEachCallback,
AfterAllCallback,
BeforeAllCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    public static final String ROUTE_COVERAGE_ENABLED = "CamelTestRouteCoverage";
    private static final Logger LOG = LoggerFactory.getLogger(CamelTestSupport.class);
    private static ThreadLocal<ModelCamelContext> threadCamelContext = new ThreadLocal();
    private static ThreadLocal<ProducerTemplate> threadTemplate = new ThreadLocal();
    private static ThreadLocal<FluentProducerTemplate> threadFluentTemplate = new ThreadLocal();
    private static ThreadLocal<ConsumerTemplate> threadConsumer = new ThreadLocal();
    private static ThreadLocal<Service> threadService = new ThreadLocal();
    protected Properties extra;
    protected volatile ModelCamelContext context;
    protected volatile ProducerTemplate template;
    protected volatile FluentProducerTemplate fluentTemplate;
    protected volatile ConsumerTemplate consumer;
    protected volatile Service camelContextService;
    @RegisterExtension
    protected CamelTestSupport camelTestSupportExtension = this;
    private boolean useRouteBuilder = true;
    private final DebugBreakpoint breakpoint = new DebugBreakpoint();
    private final StopWatch watch = new StopWatch();
    private final Map<String, String> fromEndpoints = new HashMap<String, String>();
    private static final ThreadLocal<AtomicInteger> TESTS = new ThreadLocal();
    private static final ThreadLocal<CamelTestSupport> INSTANCE = new ThreadLocal();
    private String currentTestName;
    private boolean isCreateCamelContextPerClass = false;
    private CamelRouteCoverageDumper routeCoverageDumper = new CamelRouteCoverageDumper();
    private ExtensionContext.Store globalStore;

    public void afterTestExecution(ExtensionContext context) throws Exception {
        this.watch.taken();
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        this.watch.restart();
    }

    public long timeTaken() {
        return this.watch.taken();
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.currentTestName = context.getDisplayName();
        this.globalStore = context.getStore(ExtensionContext.Namespace.GLOBAL);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        DefaultCamelContext.clearOptions();
    }

    public void beforeAll(ExtensionContext context) {
        this.isCreateCamelContextPerClass = context.getTestInstanceLifecycle().filter(lc -> lc.equals((Object)TestInstance.Lifecycle.PER_CLASS)).isPresent();
    }

    public void afterAll(ExtensionContext context) {
        CamelTestSupport support = INSTANCE.get();
        if (support != null && support.isCreateCamelContextPerClass()) {
            try {
                support.tearDownCreateCamelContextPerClass();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isUseRouteBuilder() {
        return this.useRouteBuilder;
    }

    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
    }

    public boolean isDumpRouteCoverage() {
        return false;
    }

    public boolean isUseAdviceWith() {
        return false;
    }

    public final boolean isCreateCamelContextPerClass() {
        return this.isCreateCamelContextPerClass;
    }

    public String isMockEndpoints() {
        return null;
    }

    public String isMockEndpointsAndSkip() {
        return null;
    }

    public void replaceRouteFromWith(String routeId, String fromEndpoint) {
        this.fromEndpoints.put(routeId, fromEndpoint);
    }

    public String getRouteFilterIncludePattern() {
        return null;
    }

    public String getRouteFilterExcludePattern() {
        return null;
    }

    public final String getCurrentTestName() {
        return this.currentTestName;
    }

    public boolean isUseDebugger() {
        return false;
    }

    public Service getCamelContextService() {
        return this.camelContextService;
    }

    public Service camelContextService() {
        return this.camelContextService;
    }

    public CamelContext context() {
        return this.context;
    }

    public ProducerTemplate template() {
        return this.template;
    }

    public FluentProducerTemplate fluentTemplate() {
        return this.fluentTemplate;
    }

    public ConsumerTemplate consumer() {
        return this.consumer;
    }

    public void setCamelContextService(Service service) {
        this.camelContextService = service;
        threadService.set(this.camelContextService);
    }

    @BeforeEach
    public void setUp() throws Exception {
        LOG.info("********************************************************************************");
        LOG.info("Testing: {} ({})", (Object)this.currentTestName, (Object)this.getClass().getName());
        LOG.info("********************************************************************************");
        if (this.isCreateCamelContextPerClass()) {
            INSTANCE.set(this);
            AtomicInteger v = TESTS.get();
            if (v == null) {
                v = new AtomicInteger();
                TESTS.set(v);
            }
            if (v.getAndIncrement() == 0) {
                LOG.debug("Setup CamelContext before running first test");
                this.doSpringBootCheck();
                this.setupResources();
                this.doPreSetup();
                this.doSetUp();
                this.doPostSetup();
            } else {
                LOG.debug("Reset between test methods");
                this.postProcessTest();
                MockEndpoint.resetMocks((CamelContext)this.context);
            }
        } else {
            this.doSpringBootCheck();
            this.doQuarkusCheck();
            this.setupResources();
            this.doPreSetup();
            this.doSetUp();
            this.doPostSetup();
        }
        this.watch.restart();
    }

    protected void doPreSetup() throws Exception {
    }

    protected void doPostSetup() throws Exception {
    }

    protected void doSpringBootCheck() {
        boolean springBoot = this.hasClassAnnotation("org.springframework.boot.test.context.SpringBootTest");
        if (springBoot) {
            throw new RuntimeException("Spring Boot detected: The CamelTestSupport/CamelSpringTestSupport class is not intended for Camel testing with Spring Boot.");
        }
    }

    protected void doQuarkusCheck() {
        boolean quarkus;
        boolean bl = quarkus = this.hasClassAnnotation("io.quarkus.test.junit.QuarkusTest") || this.hasClassAnnotation("org.apache.camel.quarkus.test.CamelQuarkusTest");
        if (quarkus) {
            throw new RuntimeException("Quarkus detected: The CamelTestSupport/CamelSpringTestSupport class is not intended for Camel testing with Quarkus.");
        }
    }

    protected void doSetUp() throws Exception {
        LOG.debug("setUp test");
        if (this.useJmx() || this.isRouteCoverageEnabled() || TestSupport.isCamelDebugPresent()) {
            this.enableJMX();
        } else {
            this.disableJMX();
        }
        this.context = (ModelCamelContext)this.createCamelContext();
        threadCamelContext.set(this.context);
        Assertions.assertNotNull((Object)this.context, (String)"No context found!");
        this.bindToRegistry(this.context.getRegistry());
        this.context.getShutdownStrategy().setTimeout((long)this.getShutdownTimeout());
        if (this.isUseDebugger()) {
            if (this.context.getStatus().equals((Object)ServiceStatus.Started)) {
                LOG.info("Cannot setting the Debugger to the starting CamelContext, stop the CamelContext now.");
                this.context.stop();
            }
            this.context.setDebugging(Boolean.valueOf(true));
            this.context.setDebugger((Debugger)new DefaultDebugger());
            this.context.getDebugger().addBreakpoint((Breakpoint)this.breakpoint);
        }
        this.template = this.context.createProducerTemplate();
        this.template.start();
        this.fluentTemplate = this.context.createFluentProducerTemplate();
        this.fluentTemplate.start();
        this.consumer = this.context.createConsumerTemplate();
        this.consumer.start();
        threadTemplate.set(this.template);
        threadFluentTemplate.set(this.fluentTemplate);
        threadConsumer.set(this.consumer);
        String pattern = this.isMockEndpoints();
        if (pattern != null) {
            ((ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class)).registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern));
        }
        if ((pattern = this.isMockEndpointsAndSkip()) != null) {
            ((ExtendedCamelContext)this.context.adapt(ExtendedCamelContext.class)).registerEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern, true));
        }
        PropertiesComponent pc = this.context.getPropertiesComponent();
        if (this.extra == null) {
            this.extra = this.useOverridePropertiesWithPropertiesComponent();
        }
        if (this.extra != null && !this.extra.isEmpty()) {
            pc.setOverrideProperties(this.extra);
        }
        pc.addPropertiesSource(new PropertiesSource(){

            public String getName() {
                return "junit-store";
            }

            public String getProperty(String name) {
                return (String)CamelTestSupport.this.globalStore.get((Object)name, String.class);
            }
        });
        Boolean ignore = this.ignoreMissingLocationWithPropertiesComponent();
        if (ignore != null) {
            pc.setIgnoreMissingLocation(ignore.booleanValue());
        }
        String include = this.getRouteFilterIncludePattern();
        String exclude = this.getRouteFilterExcludePattern();
        if (include != null || exclude != null) {
            LOG.info("Route filtering pattern: include={}, exclude={}", (Object)include, (Object)exclude);
            ((Model)this.context.getExtension(Model.class)).setRouteFilterPattern(include, exclude);
        }
        this.postProcessTest();
        if (this.isUseRouteBuilder()) {
            RoutesBuilder[] builders;
            for (RoutesBuilder builder : builders = this.createRouteBuilders()) {
                if (!(builder instanceof RouteConfigurationsBuilder)) continue;
                LOG.debug("Using created route configuration: {}", (Object)builder);
                this.context.addRoutesConfigurations((RouteConfigurationsBuilder)builder);
            }
            for (RoutesBuilder builder : builders) {
                LOG.debug("Using created route builder to add routes: {}", (Object)builder);
                this.context.addRoutes(builder);
            }
            for (RoutesBuilder builder : builders) {
                LOG.debug("Using created route builder to add templated routes: {}", (Object)builder);
                this.context.addTemplatedRoutes(builder);
            }
            this.replaceFromEndpoints();
            boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
            if (skip) {
                LOG.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
            } else if (this.isUseAdviceWith()) {
                LOG.info("Skipping starting CamelContext as isUseAdviceWith is set to true.");
            } else {
                this.startCamelContext();
            }
        } else {
            this.replaceFromEndpoints();
            LOG.debug("Using route builder from the created context: {}", (Object)this.context);
        }
        LOG.debug("Routing Rules are: {}", (Object)this.context.getRoutes());
        this.assertValidContext((CamelContext)this.context);
    }

    private void replaceFromEndpoints() throws Exception {
        for (final Map.Entry<String, String> entry : this.fromEndpoints.entrySet()) {
            AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition(entry.getKey()), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    this.replaceFromWith((String)entry.getValue());
                }
            });
        }
    }

    private boolean isRouteCoverageEnabled() {
        return System.getProperty(ROUTE_COVERAGE_ENABLED, "false").equalsIgnoreCase("true") || this.isDumpRouteCoverage();
    }

    @AfterEach
    public void tearDown() throws Exception {
        long time = this.watch.taken();
        LOG.info("********************************************************************************");
        LOG.info("Testing done: {} ({})", (Object)this.currentTestName, (Object)this.getClass().getName());
        LOG.info("Took: {} ({} millis)", (Object)TimeUtils.printDuration((long)time, (boolean)true), (Object)time);
        if (this.isRouteCoverageEnabled()) {
            ManagedCamelContextMBean managedCamelContext;
            String className = this.getClass().getSimpleName();
            String dir = "target/camel-route-coverage";
            String name = className + "-" + StringHelper.before((String)this.currentTestName, (String)"(") + ".xml";
            ManagedCamelContext mc = this.context != null ? (ManagedCamelContext)this.context.getExtension(ManagedCamelContext.class) : null;
            ManagedCamelContextMBean managedCamelContextMBean = managedCamelContext = mc != null ? mc.getManagedCamelContext() : null;
            if (managedCamelContext == null) {
                LOG.warn("Cannot dump route coverage to file as JMX is not enabled. Add camel-management JAR as dependency and/or override useJmx() method to enable JMX in the unit test classes.");
            } else {
                this.routeCoverageDumper.dump(managedCamelContext, this.context, dir, name, this.getClass().getName(), this.currentTestName, this.timeTaken());
            }
        }
        LOG.info("********************************************************************************");
        if (!this.isCreateCamelContextPerClass()) {
            LOG.debug("tearDown()");
            CamelTestSupport.doStopTemplates(this.consumer, this.template, this.fluentTemplate);
            this.doStopCamelContext((CamelContext)this.context, this.camelContextService);
            this.doPostTearDown();
            this.cleanupResources();
        }
    }

    void tearDownCreateCamelContextPerClass() throws Exception {
        LOG.debug("tearDownCreateCamelContextPerClass()");
        TESTS.remove();
        CamelTestSupport.doStopTemplates(threadConsumer.get(), threadTemplate.get(), threadFluentTemplate.get());
        this.doStopCamelContext((CamelContext)threadCamelContext.get(), threadService.get());
        this.doPostTearDown();
        this.cleanupResources();
    }

    protected void doPostTearDown() throws Exception {
    }

    protected void setupResources() throws Exception {
    }

    protected void cleanupResources() throws Exception {
    }

    protected int getShutdownTimeout() {
        return 10;
    }

    protected boolean useJmx() {
        return false;
    }

    protected Properties useOverridePropertiesWithPropertiesComponent() {
        return null;
    }

    protected Boolean ignoreMissingLocationWithPropertiesComponent() {
        return null;
    }

    protected void postProcessTest() throws Exception {
        this.context = threadCamelContext.get();
        this.template = threadTemplate.get();
        this.fluentTemplate = threadFluentTemplate.get();
        this.consumer = threadConsumer.get();
        this.camelContextService = threadService.get();
        this.applyCamelPostProcessor();
    }

    protected void applyCamelPostProcessor() throws Exception {
        boolean spring = this.hasClassAnnotation("org.springframework.boot.test.context.SpringBootTest", "org.springframework.context.annotation.ComponentScan");
        if (!spring) {
            ((ExtendedCamelContext)this.context.getExtension(ExtendedCamelContext.class)).getBeanPostProcessor().postProcessBeforeInitialization((Object)this, this.getClass().getName());
            ((ExtendedCamelContext)this.context.getExtension(ExtendedCamelContext.class)).getBeanPostProcessor().postProcessAfterInitialization((Object)this, this.getClass().getName());
        }
    }

    protected boolean hasClassAnnotation(String ... names) {
        for (String name : names) {
            for (Annotation ann : this.getClass().getAnnotations()) {
                String annName = ann.annotationType().getName();
                if (!annName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    protected void stopCamelContext() throws Exception {
        this.doStopCamelContext((CamelContext)this.context, this.camelContextService);
    }

    protected void doStopCamelContext(CamelContext context, Service camelContextService) {
        if (camelContextService != null) {
            if (camelContextService == threadService.get()) {
                threadService.remove();
            }
            camelContextService.stop();
        } else if (context != null) {
            if (context == threadCamelContext.get()) {
                threadCamelContext.remove();
            }
            context.stop();
        }
    }

    private static void doStopTemplates(ConsumerTemplate consumer, ProducerTemplate template, FluentProducerTemplate fluentTemplate) {
        if (consumer != null) {
            if (consumer == threadConsumer.get()) {
                threadConsumer.remove();
            }
            consumer.stop();
        }
        if (template != null) {
            if (template == threadTemplate.get()) {
                threadTemplate.remove();
            }
            template.stop();
        }
        if (fluentTemplate != null) {
            if (fluentTemplate == threadFluentTemplate.get()) {
                threadFluentTemplate.remove();
            }
            fluentTemplate.stop();
        }
    }

    protected void startCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.start();
        } else if (this.context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            this.context.start();
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        Registry registry = this.createCamelRegistry();
        DefaultCamelContext retContext = registry != null ? new DefaultCamelContext(registry) : new DefaultCamelContext();
        return retContext;
    }

    protected void bindToRegistry(Registry registry) throws Exception {
    }

    protected Registry createCamelRegistry() throws Exception {
        return null;
    }

    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    protected RoutesBuilder[] createRouteBuilders() throws Exception {
        return new RoutesBuilder[]{this.createRouteBuilder()};
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return TestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return TestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri, endpointType);
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.getMockEndpoint(uri, true);
    }

    protected MockEndpoint getMockEndpoint(String uri, boolean create) throws NoSuchEndpointException {
        String n;
        try {
            n = URISupport.normalizeUri((String)uri);
        }
        catch (Exception e2) {
            throw RuntimeCamelException.wrapRuntimeException((Throwable)e2);
        }
        int idx = n.indexOf(63);
        if (idx != -1) {
            n = n.substring(0, idx);
        }
        String target = n;
        MockEndpoint found = this.context.getEndpointRegistry().values().stream().filter(e -> e instanceof MockEndpoint).filter(e -> {
            String t = e.getEndpointUri();
            int idx2 = t.indexOf(63);
            if (idx2 != -1) {
                t = t.substring(0, idx2);
            }
            return t.equals(target);
        }).findFirst().orElse(null);
        if (found != null) {
            return found;
        }
        if (create) {
            return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
        }
        throw new NoSuchEndpointException(String.format("MockEndpoint %s does not exist.", uri));
    }

    protected void sendBody(String endpointUri, Object body) {
        this.template.send(endpointUri, exchange -> {
            Message in = exchange.getIn();
            in.setBody(body);
        });
    }

    protected void sendBody(String endpointUri, Object body, Map<String, Object> headers) {
        this.template.send(endpointUri, exchange -> {
            Message in = exchange.getIn();
            in.setBody(body);
            for (Map.Entry entry : headers.entrySet()) {
                in.setHeader((String)entry.getKey(), entry.getValue());
            }
        });
    }

    protected void sendBodies(String endpointUri, Object ... bodies) {
        for (Object body : bodies) {
            this.sendBody(endpointUri, body);
        }
    }

    protected Exchange createExchangeWithBody(Object body) {
        return TestSupport.createExchangeWithBody((CamelContext)this.context, body);
    }

    protected void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        Language language = this.assertResolveLanguage(languageName);
        Expression expression = language.createExpression(expressionText);
        Assertions.assertNotNull((Object)expression, (String)("No Expression could be created for text: " + expressionText + " language: " + language));
        TestSupport.assertExpression(expression, exchange, expectedValue);
    }

    protected void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        Language language = this.assertResolveLanguage(languageName);
        Predicate predicate = language.createPredicate(expressionText);
        Assertions.assertNotNull((Object)predicate, (String)("No Predicate could be created for text: " + expressionText + " language: " + language));
        TestSupport.assertPredicate(predicate, exchange, expected);
    }

    protected Language assertResolveLanguage(String languageName) {
        Language language = this.context.resolveLanguage(languageName);
        Assertions.assertNotNull((Object)language, (String)("Nog language found for name: " + languageName));
        return language;
    }

    protected void assertValidContext(CamelContext context) {
        Assertions.assertNotNull((Object)context, (String)"No context found!");
    }

    protected <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        Endpoint endpoint = this.context.getEndpoint(uri, type);
        Assertions.assertNotNull((Object)endpoint, (String)("No endpoint found for uri: " + uri));
        return (T)endpoint;
    }

    protected Endpoint getMandatoryEndpoint(String uri) {
        Endpoint endpoint = this.context.getEndpoint(uri);
        Assertions.assertNotNull((Object)endpoint, (String)("No endpoint found for uri: " + uri));
        return endpoint;
    }

    protected void disableJMX() {
        DefaultCamelContext.setDisableJmx((boolean)true);
    }

    protected void enableJMX() {
        DefaultCamelContext.setDisableJmx((boolean)false);
    }

    protected void debugBefore(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label) {
    }

    protected void debugAfter(Exchange exchange, Processor processor, ProcessorDefinition<?> definition, String id, String label, long timeTaken) {
    }

    @Deprecated
    protected static String fileUri(Path testDirectory) {
        return "file:" + testDirectory;
    }

    @Deprecated
    protected static String fileUri(Path testDirectory, String query) {
        return "file:" + testDirectory + (query.startsWith("?") ? "" : "/") + query;
    }

    private class DebugBreakpoint
    extends BreakpointSupport {
        private DebugBreakpoint() {
        }

        public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
            CamelTestSupport.this.debugBefore(exchange, processor, (ProcessorDefinition)definition, definition.getId(), definition.getLabel());
        }

        public void afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
            CamelTestSupport.this.debugAfter(exchange, processor, (ProcessorDefinition)definition, definition.getId(), definition.getLabel(), timeTaken);
        }
    }
}

