/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.junit5;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;

public final class ThrottlingExecutor {
    private final List<IntConsumer> beforeTasks = new ArrayList<IntConsumer>();
    private final List<IntConsumer> afterTasks = new ArrayList<IntConsumer>();
    private int repetitions;
    private long beforeWait;
    private long awaiting;
    private TimeUnit timeUnit;

    private ThrottlingExecutor() {
    }

    public static ThrottlingExecutor slowly() {
        return new ThrottlingExecutor();
    }

    public ThrottlingExecutor repeat(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public ThrottlingExecutor beforeWait() throws InterruptedException {
        Thread.sleep(this.timeUnit.toMillis(this.awaiting));
        return this;
    }

    public ThrottlingExecutor awaiting(long awaiting, TimeUnit timeUnit) {
        this.awaiting = awaiting;
        this.timeUnit = timeUnit;
        return this;
    }

    public ThrottlingExecutor beforeEach(IntConsumer beforeTask) {
        this.beforeTasks.add(beforeTask);
        return this;
    }

    public ThrottlingExecutor afterEach(IntConsumer afterTask) {
        this.afterTasks.add(afterTask);
        return this;
    }

    private static void runTasks(List<IntConsumer> taskList, Integer index) {
        for (IntConsumer consumer : taskList) {
            consumer.accept(index);
        }
    }

    public void execute() throws InterruptedException {
        for (int i = 0; i < this.repetitions; ++i) {
            ThrottlingExecutor.runTasks(this.beforeTasks, i);
            Thread.sleep(this.timeUnit.toMillis(this.awaiting));
            ThrottlingExecutor.runTasks(this.afterTasks, i);
        }
    }
}

