/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift.server;

import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerTransport;

public class ThriftThreadPoolServer
extends TThreadPoolServer {
    private final CamelContext context;
    private final ExecutorService startExecutor;

    public ThriftThreadPoolServer(Args args) {
        super((TThreadPoolServer.Args)args);
        this.context = args.context;
        this.startExecutor = args.startThreadPool;
    }

    public void serve() {
        if (!this.preServe()) {
            return;
        }
        this.startExecutor.execute(() -> {
            this.execute();
            this.waitForShutdown();
            this.context.getExecutorServiceManager().shutdownGraceful(this.getExecutorService());
            this.setServing(false);
        });
    }

    public void stop() {
        super.stop();
        this.context.getExecutorServiceManager().shutdownGraceful(this.startExecutor);
    }

    public static class Args
    extends TThreadPoolServer.Args {
        private ExecutorService startThreadPool;
        private CamelContext context;

        public Args(TServerTransport transport) {
            super(transport);
        }

        public Args startThreadPool(ExecutorService startThreadPool) {
            this.startThreadPool = startThreadPool;
            return this;
        }

        public Args context(CamelContext context) {
            this.context = context;
            return this;
        }
    }
}

