/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.torchserve.producer;

import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.torchserve.TorchServeConfiguration;
import org.apache.camel.component.torchserve.TorchServeEndpoint;
import org.apache.camel.component.torchserve.client.Inference;
import org.apache.camel.component.torchserve.client.model.ApiException;
import org.apache.camel.component.torchserve.client.model.Response;
import org.apache.camel.component.torchserve.producer.TorchServeProducer;

public class InferenceProducer
extends TorchServeProducer {
    private final Inference inference;
    private final String operation;

    public InferenceProducer(TorchServeEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.inference = endpoint.getClient().inference();
        this.operation = endpoint.getOperation();
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.operation) {
            case "ping": {
                this.ping(exchange);
                break;
            }
            case "predictions": {
                this.predictions(exchange);
                break;
            }
            case "explanations": {
                this.explanations(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + this.operation);
            }
        }
    }

    private void ping(Exchange exchange) throws ApiException {
        Response response = this.inference.ping();
        exchange.getMessage().setBody((Object)response.getStatus());
    }

    private void predictions(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        String modelName = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelName", String.class)).orElse(configuration.getModelName());
        String modelVersion = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelVersion", String.class)).orElse(configuration.getModelVersion());
        Object body = message.getBody(byte[].class);
        Object response = modelVersion == null ? this.inference.predictions(modelName, body) : this.inference.predictions(modelName, modelVersion, body);
        message.setBody(response);
    }

    private void explanations(Exchange exchange) throws ApiException {
        Message message = exchange.getMessage();
        TorchServeConfiguration configuration = this.getEndpoint().getConfiguration();
        String modelName = Optional.ofNullable((String)message.getHeader("CamelTorchServeModelName", String.class)).orElse(configuration.getModelName());
        Object response = this.inference.explanations(modelName);
        message.setBody(response);
    }
}

