/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.Tag;
import org.apache.camel.tracing.decorators.AbstractSpanDecorator;

public class CqlSpanDecorator
extends AbstractSpanDecorator {
    public static final String CASSANDRA_DB_TYPE = "cassandra";
    protected static final String CAMEL_CQL_QUERY = "CamelCqlQuery";

    @Override
    public String getComponent() {
        return "cql";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.cassandra.CassandraComponent";
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        String cql;
        super.pre(span, exchange, endpoint);
        span.setTag(Tag.DB_TYPE, CASSANDRA_DB_TYPE);
        URI uri = URI.create(endpoint.getEndpointUri());
        if (uri.getPath() != null && uri.getPath().length() > 0) {
            span.setTag(Tag.DB_INSTANCE, uri.getPath().substring(1));
        }
        if ((cql = (String)exchange.getIn().getHeader(CAMEL_CQL_QUERY, String.class)) != null) {
            span.setTag(Tag.DB_STATEMENT, cql);
        } else {
            Map<String, String> queryParameters = CqlSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
            if (queryParameters.containsKey("cql")) {
                span.setTag(Tag.DB_STATEMENT, queryParameters.get("cql"));
            }
        }
    }
}

