/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.propagation;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.camel.tracing.ExtractAdapter;
import org.apache.camel.util.CaseInsensitiveMap;

public final class CamelMessagingHeadersExtractAdapter
implements ExtractAdapter {
    private final Map<String, Object> map = new CaseInsensitiveMap();
    private final boolean jmsEncoding;

    public CamelMessagingHeadersExtractAdapter(Map<String, Object> map, boolean jmsEncoding) {
        this.jmsEncoding = jmsEncoding;
        map.entrySet().stream().filter(e -> e.getValue() instanceof String || e.getValue() instanceof byte[]).forEach(e -> {
            Object patt1596$temp = e.getValue();
            if (patt1596$temp instanceof byte[]) {
                byte[] bytes = (byte[])patt1596$temp;
                this.map.put(this.decodeDash((String)e.getKey()), new String(bytes, StandardCharsets.UTF_8));
            } else {
                this.map.put(this.decodeDash((String)e.getKey()), e.getValue());
            }
        });
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public Set<String> keys() {
        return this.map.keySet();
    }

    private String decodeDash(String key) {
        if (this.jmsEncoding) {
            return key.replace("_$dash$_", "-");
        }
        return key;
    }
}

