/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.CamelTracingService;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanDecorator;
import org.apache.camel.tracing.SpanKind;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Tracer
extends ServiceSupport
implements CamelTracingService,
RoutePolicyFactory,
StaticService {
    protected static final Map<String, SpanDecorator> DECORATORS = new HashMap<String, SpanDecorator>();
    static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private static final Logger LOG = LoggerFactory.getLogger(Tracer.class);
    protected boolean encoding;
    private final TracingLogListener logListener = new TracingLogListener();
    private final TracingEventNotifier eventNotifier = new TracingEventNotifier();
    private String excludePatterns;
    private InterceptStrategy tracingStrategy;
    private CamelContext camelContext;

    protected abstract void initTracer();

    protected abstract SpanAdapter startSendingEventSpan(String var1, SpanKind var2, SpanAdapter var3, Exchange var4, InjectAdapter var5);

    protected abstract void initContextPropagators();

    protected abstract SpanAdapter startExchangeBeginSpan(Exchange var1, SpanDecorator var2, String var3, SpanKind var4, SpanAdapter var5);

    protected abstract void finishSpan(SpanAdapter var1);

    protected abstract void inject(SpanAdapter var1, InjectAdapter var2);

    public InterceptStrategy getTracingStrategy() {
        return this.tracingStrategy;
    }

    public void setTracingStrategy(InterceptStrategy tracingStrategy) {
        this.tracingStrategy = tracingStrategy;
    }

    public void addDecorator(SpanDecorator decorator) {
        DECORATORS.put(decorator.getComponent(), decorator);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedAttribute
    public String getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(String excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    @ManagedAttribute
    public boolean isEncoding() {
        return this.encoding;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
        this.init(camelContext);
        return new TracingRoutePolicy();
    }

    public void init(CamelContext camelContext) {
        if (this.hasOtherTracerType(camelContext)) {
            LOG.warn("Could not add {} tracer type. Another tracer type, {}, was already registered. Make sure to include only one tracing dependency type.", ((Object)((Object)this)).getClass(), ((Object)((Object)((Tracer)((Object)camelContext.hasService(Tracer.class))))).getClass());
            return;
        }
        if (!camelContext.hasService((Object)this)) {
            try {
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    private boolean hasOtherTracerType(CamelContext camelContext) {
        Tracer t = (Tracer)((Object)camelContext.hasService(Tracer.class));
        if (t == null) {
            return false;
        }
        return !((Object)((Object)this)).getClass().equals(((Object)((Object)t)).getClass());
    }

    protected void doInit() {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains((Object)this)) {
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)this);
        }
        this.camelContext.getCamelContextExtension().addLogListener((LogListener)this.logListener);
        if (this.tracingStrategy != null) {
            this.camelContext.getCamelContextExtension().addInterceptStrategy(this.tracingStrategy);
        }
        this.initTracer();
        this.initContextPropagators();
        ServiceHelper.startService((Service)this.eventNotifier);
        if (Boolean.TRUE.equals(this.camelContext.isUseMDCLogging())) {
            LOG.warn("Initialized tracing component to put trace_id and span_id into MDC. This is a deprecated feature and may disappear in the future. You should replace it with the specific MDC instrumentation provided by your tracing/telemetry SDK instead. See the tracing component documentation to learn more about it.");
        }
    }

    protected void doShutdown() {
        this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.eventNotifier);
        ServiceHelper.stopService((Service)this.eventNotifier);
        this.camelContext.getRoutePolicyFactories().remove((Object)this);
    }

    protected SpanDecorator getSpanDecorator(Endpoint endpoint) {
        SpanDecorator sd = null;
        String uri = endpoint.getEndpointUri();
        String[] splitURI = StringHelper.splitOnCharacter((String)uri, (String)":", (int)2);
        if (splitURI[1] != null) {
            String scheme = splitURI[0];
            sd = DECORATORS.get(scheme);
        }
        if (sd == null && endpoint instanceof DefaultEndpoint) {
            DefaultEndpoint de = (DefaultEndpoint)endpoint;
            Component comp = de.getComponent();
            String fqn = comp.getClass().getName();
            sd = DECORATORS.values().stream().filter(d -> fqn.equals(d.getComponentClassName())).findFirst().orElse(null);
        }
        if (sd == null) {
            sd = SpanDecorator.DEFAULT;
        }
        return sd;
    }

    private boolean isExcluded(Exchange exchange, Endpoint endpoint) {
        String url = endpoint.getEndpointUri();
        if (url != null && this.excludePatterns != null) {
            for (String pattern : this.excludePatterns.split(",")) {
                pattern = pattern.trim();
                if (!EndpointHelper.matchEndpoint((CamelContext)exchange.getContext(), (String)url, (String)pattern)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ServiceLoader.load(SpanDecorator.class).forEach(d -> {
            SpanDecorator existing = DECORATORS.get(d.getComponent());
            if (existing == null || existing.getClass().isInstance(d)) {
                DECORATORS.put(d.getComponent(), (SpanDecorator)d);
            }
        });
    }

    private static final class TracingLogListener
    implements LogListener {
        private TracingLogListener() {
        }

        public String onLog(Exchange exchange, CamelLogger camelLogger, String message) {
            try {
                SpanAdapter span = ActiveSpanManager.getSpan(exchange);
                if (span != null) {
                    HashMap<String, String> fields = new HashMap<String, String>();
                    fields.put("message", message);
                    span.log(fields);
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data. This exception is ignored.", (Throwable)t);
            }
            return message;
        }
    }

    private final class TracingEventNotifier
    extends EventNotifierSupport {
        public TracingEventNotifier() {
            this.setIgnoreCamelContextEvents(true);
            this.setIgnoreCamelContextInitEvents(true);
            this.setIgnoreRouteEvents(true);
            this.setIgnoreExchangeAsyncProcessingStartedEvents(false);
        }

        public void notify(CamelEvent event) throws Exception {
            try {
                if (event instanceof CamelEvent.ExchangeSendingEvent) {
                    CamelEvent.ExchangeSendingEvent ese = (CamelEvent.ExchangeSendingEvent)event;
                    SpanDecorator sd = Tracer.this.getSpanDecorator(ese.getEndpoint());
                    if (this.shouldExclude(sd, ese.getExchange(), ese.getEndpoint())) {
                        return;
                    }
                    SpanAdapter parent = ActiveSpanManager.getSpan(ese.getExchange());
                    InjectAdapter injectAdapter = sd.getInjectAdapter(ese.getExchange().getIn().getHeaders(), Tracer.this.encoding);
                    SpanAdapter span = Tracer.this.startSendingEventSpan(sd.getOperationName(ese.getExchange(), ese.getEndpoint()), sd.getInitiatorSpanKind(), parent, ese.getExchange(), injectAdapter);
                    sd.pre(span, ese.getExchange(), ese.getEndpoint());
                    Tracer.this.inject(span, injectAdapter);
                    ActiveSpanManager.activate(ese.getExchange(), span);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Tracing: start client span: {} with parent {}", (Object)span, (Object)parent);
                    }
                } else if (event instanceof CamelEvent.ExchangeSentEvent) {
                    CamelEvent.ExchangeSentEvent ese = (CamelEvent.ExchangeSentEvent)event;
                    SpanDecorator sd = Tracer.this.getSpanDecorator(ese.getEndpoint());
                    if (this.shouldExclude(sd, ese.getExchange(), ese.getEndpoint())) {
                        return;
                    }
                    SpanAdapter span = ActiveSpanManager.getSpan(ese.getExchange());
                    if (span != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Tracing: stop client span: {}", (Object)span);
                        }
                        sd.post(span, ese.getExchange(), ese.getEndpoint());
                        ActiveSpanManager.deactivate(ese.getExchange());
                        Tracer.this.finishSpan(span);
                    } else {
                        LOG.warn("Tracing: could not find managed span for exchange: {}", (Object)ese.getExchange());
                    }
                } else if (event instanceof CamelEvent.ExchangeAsyncProcessingStartedEvent) {
                    CamelEvent.ExchangeAsyncProcessingStartedEvent eap = (CamelEvent.ExchangeAsyncProcessingStartedEvent)event;
                    ActiveSpanManager.endScope(eap.getExchange());
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data. This exception is ignored.", (Throwable)t);
            }
        }

        private boolean shouldExclude(SpanDecorator sd, Exchange exchange, Endpoint endpoint) {
            return !sd.newSpan() || Tracer.this.isExcluded(exchange, endpoint);
        }
    }

    private final class TracingRoutePolicy
    extends RoutePolicySupport {
        private TracingRoutePolicy() {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            try {
                if (Tracer.this.isExcluded(exchange, route.getEndpoint())) {
                    return;
                }
                SpanDecorator sd = Tracer.this.getSpanDecorator(route.getEndpoint());
                SpanAdapter parent = ActiveSpanManager.getSpan(exchange);
                SpanAdapter span = Tracer.this.startExchangeBeginSpan(exchange, sd, sd.getOperationName(exchange, route.getEndpoint()), sd.getReceiverSpanKind(), parent);
                sd.pre(span, exchange, route.getEndpoint());
                ActiveSpanManager.activate(exchange, span);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Tracing: start server span={} with parent {}", (Object)span, (Object)parent);
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data. This exception is ignored.", (Throwable)t);
            }
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            try {
                if (Tracer.this.isExcluded(exchange, route.getEndpoint())) {
                    return;
                }
                SpanAdapter span = ActiveSpanManager.getSpan(exchange);
                if (span != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Tracing: finish server span={}", (Object)span);
                    }
                    SpanDecorator sd = Tracer.this.getSpanDecorator(route.getEndpoint());
                    sd.post(span, exchange, route.getEndpoint());
                    Tracer.this.finishSpan(span);
                    ActiveSpanManager.deactivate(exchange);
                } else {
                    LOG.warn("Tracing: could not find managed span for exchange: {}", (Object)exchange);
                }
            }
            catch (Exception t) {
                LOG.warn("Tracing: Failed to capture tracing data. This exception is ignored.", (Throwable)t);
            }
        }
    }
}

