/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.ExtractAdapter;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanKind;
import org.apache.camel.tracing.Tag;
import org.apache.camel.tracing.decorators.AbstractSpanDecorator;
import org.apache.camel.tracing.propagation.CamelMessagingHeadersExtractAdapter;
import org.apache.camel.tracing.propagation.CamelMessagingHeadersInjectAdapter;

public abstract class AbstractMessagingSpanDecorator
extends AbstractSpanDecorator {
    @Deprecated
    public static final String MESSAGE_BUS_ID = "message_bus.id";

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return this.getDestination(exchange, endpoint);
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        span.setTag(Tag.MESSAGE_BUS_DESTINATION, this.getDestination(exchange, endpoint));
        String messageId = this.getMessageId(exchange);
        if (messageId != null) {
            span.setTag(MESSAGE_BUS_ID, messageId);
            span.setTag("messaging.message.id", messageId);
        }
    }

    protected String getDestination(Exchange exchange, Endpoint endpoint) {
        return AbstractMessagingSpanDecorator.stripSchemeAndOptions(endpoint);
    }

    @Override
    public SpanKind getInitiatorSpanKind() {
        return SpanKind.PRODUCER;
    }

    @Override
    public SpanKind getReceiverSpanKind() {
        return SpanKind.CONSUMER;
    }

    protected String getMessageId(Exchange exchange) {
        return null;
    }

    @Override
    public ExtractAdapter getExtractAdapter(Map<String, Object> map, boolean jmsEncoding) {
        return new CamelMessagingHeadersExtractAdapter(map, jmsEncoding);
    }

    @Override
    public InjectAdapter getInjectAdapter(Map<String, Object> map, boolean jmsEncoding) {
        return new CamelMessagingHeadersInjectAdapter(map, jmsEncoding);
    }
}

