/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio;

import com.twilio.type.PhoneNumber;
import org.apache.camel.component.twilio.TwilioConfiguration;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="incoming-phone-number", description="", apiMethods={@ApiMethod(methodName="creator", description="Create a IncomingPhoneNumberCreator to execute create", signatures={"com.twilio.rest.api.v2010.account.IncomingPhoneNumberCreator creator(String areaCode)", "com.twilio.rest.api.v2010.account.IncomingPhoneNumberCreator creator(com.twilio.type.PhoneNumber phoneNumber)", "com.twilio.rest.api.v2010.account.IncomingPhoneNumberCreator creator(String pathAccountSid, String areaCode)", "com.twilio.rest.api.v2010.account.IncomingPhoneNumberCreator creator(String pathAccountSid, com.twilio.type.PhoneNumber phoneNumber)"}), @ApiMethod(methodName="deleter", description="Create a IncomingPhoneNumberDeleter to execute delete", signatures={"com.twilio.rest.api.v2010.account.IncomingPhoneNumberDeleter deleter(String pathSid)", "com.twilio.rest.api.v2010.account.IncomingPhoneNumberDeleter deleter(String pathAccountSid, String pathSid)"}), @ApiMethod(methodName="fetcher", description="Create a IncomingPhoneNumberFetcher to execute fetch", signatures={"com.twilio.rest.api.v2010.account.IncomingPhoneNumberFetcher fetcher(String pathSid)", "com.twilio.rest.api.v2010.account.IncomingPhoneNumberFetcher fetcher(String pathAccountSid, String pathSid)"}), @ApiMethod(methodName="reader", description="Create a IncomingPhoneNumberReader to execute read", signatures={"com.twilio.rest.api.v2010.account.IncomingPhoneNumberReader reader()", "com.twilio.rest.api.v2010.account.IncomingPhoneNumberReader reader(String pathAccountSid)"}), @ApiMethod(methodName="updater", description="Create a IncomingPhoneNumberUpdater to execute update", signatures={"com.twilio.rest.api.v2010.account.IncomingPhoneNumberUpdater updater(String pathSid)", "com.twilio.rest.api.v2010.account.IncomingPhoneNumberUpdater updater(String pathAccountSid, String pathSid)"})}, aliases={"^creator$=create", "^deleter$=delete", "^fetcher$=fetch", "^reader$=read", "^updater$=update"})
@UriParams
@Configurer(extended=true)
public final class IncomingPhoneNumberEndpointConfiguration
extends TwilioConfiguration {
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="The desired area code for the new phone number")})
    private String areaCode;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="The SID of the Account that will create the resource"), @ApiMethod(methodName="deleter", description="The SID of the Account that created the resources to delete"), @ApiMethod(methodName="fetcher", description="The SID of the Account that created the resource to fetch"), @ApiMethod(methodName="reader", description="The SID of the Account that created the resources to read"), @ApiMethod(methodName="updater", description="The SID of the Account that created the resource to update")})
    private String pathAccountSid;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="deleter", description="The unique string that identifies the resource"), @ApiMethod(methodName="fetcher", description="The unique string that identifies the resource"), @ApiMethod(methodName="updater", description="The unique string that identifies the resource")})
    private String pathSid;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="creator", description="The phone number to purchase in E.164 format")})
    private PhoneNumber phoneNumber;

    public String getAreaCode() {
        return this.areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getPathAccountSid() {
        return this.pathAccountSid;
    }

    public void setPathAccountSid(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public String getPathSid() {
        return this.pathSid;
    }

    public void setPathSid(String pathSid) {
        this.pathSid = pathSid;
    }

    public PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }
}

