/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.component.twitter.Twitter4JFactory;
import org.apache.camel.component.twitter.TwitterComponent;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import org.apache.camel.component.twitter.consumer.TwitterConsumerDirect;
import org.apache.camel.component.twitter.data.EndpointType;
import twitter4j.Twitter;

public class TwitterEndpointDirect
extends DirectEndpoint
implements TwitterEndpoint {
    private Twitter twitter;
    private TwitterConfiguration properties;

    public TwitterEndpointDirect(String uri, TwitterComponent component, TwitterConfiguration properties) {
        super(uri, (Component)component);
        this.properties = properties;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Twitter4JConsumer twitter4jConsumer = Twitter4JFactory.getConsumer(this, this.getEndpointUri());
        return new TwitterConsumerDirect(this, processor, twitter4jConsumer);
    }

    public Producer createProducer() throws Exception {
        return Twitter4JFactory.getProducer(this, this.getEndpointUri());
    }

    protected void doStart() {
        this.twitter = this.properties.getTwitterInstance();
    }

    @Override
    public Twitter getTwitter() {
        return this.twitter;
    }

    @Override
    public TwitterConfiguration getProperties() {
        return this.properties;
    }

    @Override
    public EndpointType getEndpointType() {
        return EndpointType.DIRECT;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOptionalOut;
    }
}

