/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.producer;

import java.util.List;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.impl.DefaultProducer;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Tweet;
import twitter4j.Twitter;

public class SearchProducer
extends DefaultProducer {
    private long lastId;
    private TwitterEndpoint twitterEndpoint;

    public SearchProducer(TwitterEndpoint te) {
        super((Endpoint)te);
        this.twitterEndpoint = te;
    }

    public void process(Exchange exchange) throws Exception {
        String keywords = (String)exchange.getIn().getHeader("CamelTwitterKeywords", String.class);
        if (keywords == null) {
            keywords = this.twitterEndpoint.getProperties().getKeywords();
        }
        if (keywords == null) {
            throw new CamelExchangeException("No keywords to use for query", exchange);
        }
        Query query = new Query(keywords);
        if (this.lastId != 0L) {
            query.setSinceId(this.lastId);
        }
        Twitter twitter = this.twitterEndpoint.getTwitter();
        this.log.debug("Searching twitter with keywords: {}", (Object)keywords);
        QueryResult results = twitter.search(query);
        List list = results.getTweets();
        for (Tweet t : list) {
            long newId = t.getId();
            if (newId <= this.lastId) continue;
            this.lastId = newId;
        }
        exchange.getIn().setBody((Object)list);
    }
}

