/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer.search;

import java.util.Collections;
import java.util.List;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class SearchConsumer
extends Twitter4JConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(SearchConsumer.class);

    public SearchConsumer(TwitterEndpoint te) {
        super(te);
    }

    public List<Status> pollConsume() throws TwitterException {
        String keywords = this.te.getProperties().getKeywords();
        Query query = new Query(keywords);
        if (this.te.getProperties().isFilterOld()) {
            query.setSinceId(this.lastId);
        }
        LOG.debug("Searching twitter with keywords: {}", (Object)keywords);
        return this.search(query);
    }

    public List<Status> directConsume() throws TwitterException {
        String keywords = this.te.getProperties().getKeywords();
        if (keywords == null || keywords.trim().length() == 0) {
            return Collections.emptyList();
        }
        Query query = new Query(keywords);
        LOG.debug("Searching twitter with keywords: {}", (Object)keywords);
        return this.search(query);
    }

    private List<Status> search(Query query) throws TwitterException {
        Integer numberOfPages = 1;
        if (ObjectHelper.isNotEmpty((Object)this.te.getProperties().getLang())) {
            query.setLang(this.te.getProperties().getLang());
        }
        if (ObjectHelper.isNotEmpty((Object)this.te.getProperties().getCount())) {
            query.setCount(this.te.getProperties().getCount().intValue());
        }
        if (ObjectHelper.isNotEmpty((Object)this.te.getProperties().getNumberOfPages())) {
            numberOfPages = this.te.getProperties().getNumberOfPages();
        }
        LOG.debug("Searching with " + numberOfPages + " pages.");
        Twitter twitter = this.te.getProperties().getTwitter();
        QueryResult qr = twitter.search(query);
        List tweets = qr.getTweets();
        for (int i = 1; i < numberOfPages && qr.hasNext(); ++i) {
            qr = twitter.search(qr.nextQuery());
            tweets.addAll(qr.getTweets());
        }
        if (this.te.getProperties().isFilterOld()) {
            for (Status t : tweets) {
                this.checkLastId(t.getId());
            }
        }
        return tweets;
    }
}

