/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.timeline;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.AbstractTwitterConsumerHandler;
import org.apache.camel.component.twitter.consumer.TwitterEventType;
import twitter4j.Status;
import twitter4j.TwitterException;

abstract class AbstractStatusConsumerHandler
extends AbstractTwitterConsumerHandler {
    AbstractStatusConsumerHandler(TwitterEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public List<Exchange> pollConsume() throws TwitterException {
        List<Status> statusList = this.doPoll();
        for (int i = 0; i < statusList.size(); ++i) {
            this.setLastIdIfGreater(statusList.get(i).getId());
        }
        return TwitterEventType.STATUS.createExchangeList(this.endpoint, statusList);
    }

    @Override
    public List<Exchange> directConsume() throws TwitterException {
        return TwitterEventType.STATUS.createExchangeList(this.endpoint, this.doDirect());
    }

    protected abstract List<Status> doPoll() throws TwitterException;

    protected abstract List<Status> doDirect() throws TwitterException;
}

