/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.consumer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Paging;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public abstract class AbstractTwitterConsumerHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final TwitterEndpoint endpoint;
    private long lastId;

    protected AbstractTwitterConsumerHandler(TwitterEndpoint endpoint) {
        this.endpoint = endpoint;
        this.lastId = -1L;
    }

    public abstract List<Exchange> pollConsume() throws TwitterException;

    public abstract List<Exchange> directConsume() throws TwitterException;

    protected void setLastIdIfGreater(long newId) {
        if (newId > this.lastId) {
            this.lastId = newId;
        }
    }

    public void setLastId(long sinceId) {
        this.lastId = sinceId;
    }

    protected Twitter getTwitter() {
        return this.endpoint.getProperties().getTwitter();
    }

    protected long getLastId() {
        return this.lastId;
    }

    protected Paging getLastIdPaging() {
        Integer pages = this.endpoint.getProperties().getNumberOfPages();
        Integer count = this.endpoint.getProperties().getCount();
        if (pages != null && count != null) {
            return new Paging(pages.intValue(), count.intValue(), this.lastId);
        }
        if (pages != null) {
            return new Paging(pages.intValue(), this.lastId);
        }
        return new Paging(this.lastId);
    }
}

