/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.search;

import java.util.Collections;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.AbstractTwitterConsumerHandler;
import org.apache.camel.component.twitter.consumer.TwitterEventType;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.v1.GeoLocation;
import twitter4j.v1.Query;
import twitter4j.v1.QueryResult;
import twitter4j.v1.Status;

public class SearchConsumerHandler
extends AbstractTwitterConsumerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SearchConsumerHandler.class);
    private String keywords;

    public SearchConsumerHandler(TwitterEndpoint te, String keywords) {
        super(te);
        this.keywords = keywords;
    }

    @Override
    public List<Exchange> pollConsume() throws TwitterException {
        Query query;
        String keywords = this.keywords;
        if (keywords != null && keywords.trim().length() > 0) {
            query = Query.of((String)keywords);
            LOG.debug("Searching twitter with keywords: {}", (Object)keywords);
        } else {
            query = Query.of((String)"");
            LOG.debug("Searching twitter without keywords.");
        }
        if (this.endpoint.getProperties().isFilterOld()) {
            query.sinceId(this.getLastId());
        }
        return this.search(query);
    }

    @Override
    public List<Exchange> directConsume() throws TwitterException {
        String keywords = this.keywords;
        if (keywords == null || keywords.trim().length() == 0) {
            return Collections.emptyList();
        }
        Query query = Query.of((String)keywords);
        LOG.debug("Searching twitter with keywords: {}", (Object)keywords);
        return this.search(query);
    }

    private List<Exchange> search(Query query) throws TwitterException {
        Integer numberOfPages = 1;
        if (ObjectHelper.isNotEmpty((String)this.endpoint.getProperties().getLang())) {
            query.lang(this.endpoint.getProperties().getLang());
        }
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getCount())) {
            query.count(this.endpoint.getProperties().getCount().intValue());
        }
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getNumberOfPages())) {
            numberOfPages = this.endpoint.getProperties().getNumberOfPages();
        }
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getLatitude()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getLongitude()) && ObjectHelper.isNotEmpty((Object)this.endpoint.getProperties().getRadius())) {
            GeoLocation location = GeoLocation.of((double)this.endpoint.getProperties().getLatitude(), (double)this.endpoint.getProperties().getLongitude());
            query.geoCode(location, this.endpoint.getProperties().getRadius().doubleValue(), Query.Unit.valueOf((String)this.endpoint.getProperties().getDistanceMetric()));
            LOG.debug("Searching with additional geolocation parameters.");
        }
        LOG.debug("Searching with {} pages.", (Object)numberOfPages);
        Twitter twitter = this.getTwitter();
        QueryResult qr = twitter.v1().search().search(query);
        List tweets = qr.getTweets();
        for (int i = 1; i < numberOfPages && qr.hasNext(); ++i) {
            qr = twitter.v1().search().search(qr.nextQuery());
            tweets.addAll(qr.getTweets());
        }
        if (this.endpoint.getProperties().isFilterOld()) {
            for (Status status : tweets) {
                this.setLastIdIfGreater(status.getId());
            }
        }
        return TwitterEventType.STATUS.createExchangeList(this.endpoint, tweets);
    }
}

