/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

public abstract class AbstractTwitterComponent
extends HealthCheckComponent {
    @Metadata(label="security", secret=true)
    private String consumerKey;
    @Metadata(label="security", secret=true)
    private String consumerSecret;
    @Metadata(label="security", secret=true)
    private String accessToken;
    @Metadata(label="security", secret=true)
    private String accessTokenSecret;
    @Metadata(label="proxy")
    private String httpProxyHost;
    @Metadata(label="proxy")
    private String httpProxyUser;
    @Metadata(label="proxy")
    private String httpProxyPassword;
    @Metadata(label="proxy")
    private Integer httpProxyPort;

    protected AbstractTwitterComponent(String componentVerifierScheme) {
        this(null, componentVerifierScheme);
    }

    protected AbstractTwitterComponent(CamelContext context, String componentVerifierScheme) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TwitterConfiguration properties = new TwitterConfiguration();
        properties.setConsumerKey(this.consumerKey);
        properties.setConsumerSecret(this.consumerSecret);
        properties.setAccessToken(this.accessToken);
        properties.setAccessTokenSecret(this.accessTokenSecret);
        properties.setHttpProxyHost(this.httpProxyHost);
        properties.setHttpProxyUser(this.httpProxyUser);
        properties.setHttpProxyPassword(this.httpProxyPassword);
        if (this.httpProxyPort != null) {
            properties.setHttpProxyPort(this.httpProxyPort);
        }
        this.setProperties(properties, parameters);
        Endpoint answer = this.doCreateEndpoint(properties, uri, remaining, parameters);
        properties.checkComplete();
        return answer;
    }

    protected abstract Endpoint doCreateEndpoint(TwitterConfiguration var1, String var2, String var3, Map<String, Object> var4) throws Exception;

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyUser(String httpProxyUser) {
        this.httpProxyUser = httpProxyUser;
    }

    public String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }
}

