/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import java.util.HashMap;
import java.util.Map;

public class CamelPathHandler
extends PathHandler {
    private Map<String, HttpHandler> handlers = new HashMap<String, HttpHandler>();
    private String handlerString;

    public CamelPathHandler(HttpHandler defaultHandler) {
        super(defaultHandler);
    }

    public synchronized PathHandler addPrefixPath(String path, HttpHandler handler) {
        super.addPrefixPath(path, handler);
        this.handlers.put(path, handler);
        this.handlerString = null;
        return this;
    }

    public synchronized PathHandler addExactPath(String path, HttpHandler handler) {
        super.addExactPath(path, handler);
        this.handlers.put(path, handler);
        this.handlerString = null;
        return this;
    }

    public synchronized PathHandler removePrefixPath(String path) {
        super.removePrefixPath(path);
        this.handlers.remove(path);
        this.handlerString = null;
        return this;
    }

    public synchronized PathHandler removeExactPath(String path) {
        super.removeExactPath(path);
        this.handlers.remove(path);
        this.handlerString = null;
        return this;
    }

    public HttpHandler getHandler(String path) {
        return this.handlers.get(path);
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public String toString() {
        if (this.handlerString == null) {
            this.handlerString = "CamelPathHandler[" + this.handlers + "]";
        }
        return this.handlerString;
    }
}

