/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.MimeMappings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.component.undertow.ExchangeHeaders;
import org.apache.camel.component.undertow.handlers.CamelWebSocketHandler;

public class CamelMethodHandler
implements HttpHandler {
    private static final String DEFAULT_HANDLER_KEY = "";
    private static final String[] DEFAULT_METHODS = new String[]{""};
    private final Map<String, MethodEntry> methodMap = new ConcurrentHashMap<String, MethodEntry>();
    private String handlerString;

    CamelMethodHandler() {
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HttpHandler handler = null;
        MethodEntry entry = this.methodMap.get(exchange.getRequestMethod().toString());
        if (entry != null && (handler = entry.handler) != null) {
            handler.handleRequest(exchange);
        } else {
            entry = this.methodMap.get(DEFAULT_HANDLER_KEY);
            if (entry != null && (handler = entry.handler) != null) {
                handler.handleRequest(exchange);
            } else {
                exchange.setStatusCode(405);
                exchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_TYPE, (String)MimeMappings.DEFAULT_MIME_MAPPINGS.get("txt"));
                exchange.getResponseHeaders().put(ExchangeHeaders.CONTENT_LENGTH, 0L);
                exchange.endExchange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpHandler add(String methods, HttpHandler handler) {
        HttpHandler result = null;
        Map<String, MethodEntry> map = this.methodMap;
        synchronized (map) {
            for (String method : this.splitMethods(methods)) {
                MethodEntry en = this.methodMap.computeIfAbsent(method, m -> new MethodEntry());
                result = en.addRef(handler, method);
            }
        }
        this.handlerString = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String methods) {
        boolean result;
        Map<String, MethodEntry> map = this.methodMap;
        synchronized (map) {
            for (String method : this.splitMethods(methods)) {
                MethodEntry en2 = this.methodMap.get(method);
                if (en2 == null) continue;
                en2.removeRef();
            }
            result = this.methodMap.values().stream().mapToInt(en -> en.refCount).sum() == 0;
        }
        this.handlerString = null;
        return result;
    }

    public String toString() {
        if (this.handlerString == null) {
            this.handlerString = "CamelMethodHandler[" + String.valueOf(this.methodMap) + "]";
        }
        return this.handlerString;
    }

    private String[] splitMethods(String methods) {
        String[] result = methods != null ? methods.split(",") : DEFAULT_METHODS;
        return result.length == 0 ? DEFAULT_METHODS : result;
    }

    static class MethodEntry {
        private int refCount;
        private HttpHandler handler;

        MethodEntry() {
        }

        public HttpHandler addRef(HttpHandler handler, String method) {
            if (this.handler == null) {
                this.handler = handler;
                ++this.refCount;
                return handler;
            }
            if ("OPTIONS".equals(method) || CamelWebSocketHandler.class == this.handler.getClass() && CamelWebSocketHandler.class == handler.getClass()) {
                ++this.refCount;
                return this.handler;
            }
            throw new IllegalArgumentException(String.format("Duplicate handler for %s method: '%s', '%s'", method, this.handler, handler));
        }

        public void removeRef() {
            if (--this.refCount == 0) {
                this.handler = null;
            }
        }

        public String toString() {
            return this.handler == null ? "null" : this.handler.toString();
        }
    }
}

