/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.univocity;

import com.univocity.parsers.common.AbstractWriter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.support.ExchangeHelper;

final class Marshaller<W extends AbstractWriter<?>> {
    private final Lock headersLock = new ReentrantLock();
    private final LinkedHashSet<String> headers = new LinkedHashSet();
    private final boolean adaptHeaders;

    Marshaller(String[] headers, boolean adaptHeaders) {
        if (headers != null) {
            this.headers.addAll(Arrays.asList(headers));
        }
        this.adaptHeaders = adaptHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object body, W writer) throws NoTypeConversionAvailableException {
        try {
            List list = (List)ExchangeHelper.convertToType((Exchange)exchange, List.class, (Object)body);
            if (list != null) {
                for (Object row : list) {
                    this.writeRow(exchange, row, writer);
                }
            } else {
                this.writeRow(exchange, body, writer);
            }
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRow(Exchange exchange, Object row, W writer) throws NoTypeConversionAvailableException {
        Map map = (Map)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Map.class, (Object)row);
        if (this.adaptHeaders) {
            this.headersLock.lock();
            try {
                for (Object key : map.keySet()) {
                    this.headers.add((String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, key));
                }
                this.writeRow(map, writer);
            }
            finally {
                this.headersLock.unlock();
            }
        } else {
            this.writeRow(map, writer);
        }
    }

    private void writeRow(Map<?, ?> map, W writer) {
        Object[] values = new Object[this.headers.size()];
        int index = 0;
        for (String header : this.headers) {
            values[index++] = map.get(header);
        }
        writer.writeRow(values);
    }
}

