/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class SensitiveUtils {
    private static final Set<String> SENSITIVE_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("accesskey", "accesstoken", "accesstokensecret", "accountkey", "accountsid", "acltoken", "api_key", "api_secret", "apipassword", "apiuser", "apiusername", "authkey", "authorizationtoken", "blobaccesskey", "blobstoragesharedkeycredential", "certresourcepassword", "cipherkey", "clientid", "clientsecret", "clientsecretcredential", "connectionstring", "consumerkey", "consumersecret", "emailaddress", "httpproxypassword", "keystore", "login", "oauthclientid", "oauthclientsecret", "oauthtoken", "oauthtokenurl", "p12filename", "passcode", "passphrase", "password", "privatekey", "privatekeyfile", "privatekeyname", "privatekeypassword", "proxyauthpassword", "proxyauthusername", "proxypassword", "proxyuser", "publickeyid", "publishkey", "queueownerawsaccountid", "refreshtoken", "sascredential", "sasljaasconfig", "sassignature", "secret", "secretkey", "securerandom", "sessiontoken", "sharedaccesskey", "sourceblobaccesskey", "sslkeypassword", "sslkeystore", "sslkeystorepassword", "sslpassword", "ssltruststorepassword", "subscribekey", "systemid", "token", "tokencredential", "user", "username", "userpassword", "verificationcode", "webhookverifytoken", "zookeeperpassword")));
    private static final String SENSITIVE_PATTERN = "\\Qaccesskey\\E|\\Qaccesstoken\\E|\\Qaccesstokensecret\\E|\\Qaccountkey\\E|\\Qaccountsid\\E|\\Qacltoken\\E|\\Qapi_key\\E|\\Qapi_secret\\E|\\Qapipassword\\E|\\Qapiuser\\E|\\Qapiusername\\E|\\Qauthkey\\E|\\Qauthorizationtoken\\E|\\Qblobaccesskey\\E|\\Qblobstoragesharedkeycredential\\E|\\Qcertresourcepassword\\E|\\Qcipherkey\\E|\\Qclientid\\E|\\Qclientsecret\\E|\\Qclientsecretcredential\\E|\\Qconnectionstring\\E|\\Qconsumerkey\\E|\\Qconsumersecret\\E|\\Qemailaddress\\E|\\Qhttpproxypassword\\E|\\Qkeystore\\E|\\Qlogin\\E|\\Qoauthclientid\\E|\\Qoauthclientsecret\\E|\\Qoauthtoken\\E|\\Qoauthtokenurl\\E|\\Qp12filename\\E|\\Qpasscode\\E|\\Qpassphrase\\E|\\Qpassword\\E|\\Qprivatekey\\E|\\Qprivatekeyfile\\E|\\Qprivatekeyname\\E|\\Qprivatekeypassword\\E|\\Qproxyauthpassword\\E|\\Qproxyauthusername\\E|\\Qproxypassword\\E|\\Qproxyuser\\E|\\Qpublickeyid\\E|\\Qpublishkey\\E|\\Qqueueownerawsaccountid\\E|\\Qrefreshtoken\\E|\\Qsascredential\\E|\\Qsasljaasconfig\\E|\\Qsassignature\\E|\\Qsecret\\E|\\Qsecretkey\\E|\\Qsecurerandom\\E|\\Qsessiontoken\\E|\\Qsharedaccesskey\\E|\\Qsourceblobaccesskey\\E|\\Qsslkeypassword\\E|\\Qsslkeystore\\E|\\Qsslkeystorepassword\\E|\\Qsslpassword\\E|\\Qssltruststorepassword\\E|\\Qsubscribekey\\E|\\Qsystemid\\E|\\Qtoken\\E|\\Qtokencredential\\E|\\Quser\\E|\\Qusername\\E|\\Quserpassword\\E|\\Qverificationcode\\E|\\Qwebhookverifytoken\\E|\\Qzookeeperpassword\\E";

    private SensitiveUtils() {
    }

    public static Set<String> getSensitiveKeys() {
        return SENSITIVE_KEYS;
    }

    public static String getSensitivePattern() {
        return SENSITIVE_PATTERN;
    }

    public static boolean containsSensitive(String text) {
        int lastPeriod = text.lastIndexOf(46);
        if (lastPeriod >= 0) {
            text = text.substring(lastPeriod + 1);
        }
        text = text.toLowerCase(Locale.ENGLISH);
        text = text.replace("-", "");
        return SENSITIVE_KEYS.contains(text);
    }
}

