/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.velocity;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.velocity.VelocityEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ResourceHelper;
import org.apache.velocity.app.VelocityEngine;

public class VelocityComponent
extends UriEndpointComponent {
    @Metadata(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @Metadata(defaultValue="false")
    private boolean allowContextMapAll;
    @Metadata(label="advanced")
    private VelocityEngine velocityEngine;

    public VelocityComponent() {
        super(VelocityEndpoint.class);
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        VelocityEndpoint answer = new VelocityEndpoint(uri, this, remaining);
        answer.setContentCache(cache);
        answer.setVelocityEngine(this.velocityEngine);
        answer.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        answer.setAllowContextMapAll(this.allowContextMapAll);
        this.setProperties((Object)answer, parameters);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }
}

