/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.common;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.vertx.common.VertxJsonObjectConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class VertxJsonObjectConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        VertxJsonObjectConverterLoader.addTypeConverter(registry, byte[].class, JsonObject.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toBytes((JsonObject)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, Buffer.class, JsonObject.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toBuffer((JsonObject)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, JsonObject.class, byte[].class, false, (type, exchange, value) -> VertxJsonObjectConverter.toJsonObject((byte[])value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, JsonObject.class, ByteBuf.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toJsonObject((ByteBuf)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, JsonObject.class, Buffer.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toJsonObject((Buffer)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, JsonObject.class, InputStream.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toJsonObject((InputStream)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, JsonObject.class, String.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toJsonObject((String)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, JsonObject.class, Map.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toJsonObject((Map)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, InputStream.class, JsonObject.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toInputStream((JsonObject)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, String.class, JsonObject.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toString((JsonObject)value));
        VertxJsonObjectConverterLoader.addTypeConverter(registry, Map.class, JsonObject.class, false, (type, exchange, value) -> VertxJsonObjectConverter.toMap((JsonObject)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

