/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.vertx.core.Vertx;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.WebClientSession;
import io.vertx.ext.web.client.spi.CookieStore;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.vertx.common.VertxHelper;
import org.apache.camel.component.vertx.http.VertxHttpComponent;
import org.apache.camel.component.vertx.http.VertxHttpConfiguration;
import org.apache.camel.component.vertx.http.VertxHttpConstants;
import org.apache.camel.component.vertx.http.VertxHttpProducer;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.5.0", scheme="vertx-http", title="Vert.x HTTP Client", syntax="vertx-http:httpUri", category={Category.HTTP}, producerOnly=true, lenientProperties=true, headersClass=VertxHttpConstants.class)
public class VertxHttpEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriParam
    private final VertxHttpConfiguration configuration;
    private WebClient webClient;
    private int minOkRange;
    private int maxOkRange;

    public VertxHttpEndpoint(String uri, VertxHttpComponent component, VertxHttpConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public String getServiceUrl() {
        if (this.configuration != null && this.configuration.getHttpUri() != null) {
            return this.configuration.getHttpUri().toString();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "http";
    }

    public VertxHttpComponent getComponent() {
        return (VertxHttpComponent)super.getComponent();
    }

    protected void doInit() throws Exception {
        String range = this.configuration.getOkStatusCodeRange();
        this.parseStatusRange(range);
    }

    private void parseStatusRange(String range) {
        if (!range.contains(",") && !HttpUtil.parseStatusRange((String)range, this::setRanges)) {
            this.maxOkRange = this.minOkRange = Integer.parseInt(range);
        }
    }

    private void setRanges(int minOkRange, int maxOkRange) {
        this.minOkRange = minOkRange;
        this.maxOkRange = maxOkRange;
    }

    public Producer createProducer() throws Exception {
        return new VertxHttpProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("vertx-http consumers are not supported");
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.webClient == null) {
            SSLContextParameters sslContextParameters;
            WebClientOptions options = this.configuration.getWebClientOptions();
            if (options == null) {
                options = new WebClientOptions();
                options.setTryUseCompression(this.configuration.isUseCompression());
                options.setConnectTimeout(this.configuration.getConnectTimeout());
                this.configureProxyOptionsIfRequired(options);
            }
            if ((sslContextParameters = this.configuration.getSslContextParameters()) != null) {
                VertxHelper.setupSSLOptions((CamelContext)this.getCamelContext(), (SSLContextParameters)sslContextParameters, (TCPSSLOptions)options);
            }
            this.webClient = WebClient.create((Vertx)this.getVertx(), (WebClientOptions)options);
            if (this.configuration.isSessionManagement()) {
                CookieStore cookieStore = this.configuration.getCookieStore() == null ? CookieStore.build() : this.configuration.getCookieStore();
                this.webClient = WebClientSession.create((WebClient)this.webClient, (CookieStore)cookieStore);
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.webClient != null) {
            this.webClient.close();
            this.webClient = null;
        }
    }

    public boolean isLenientProperties() {
        return true;
    }

    public VertxHttpConfiguration getConfiguration() {
        return this.configuration;
    }

    protected Vertx getVertx() {
        return this.getComponent().getVertx();
    }

    protected WebClient getWebClient() {
        return this.webClient;
    }

    protected boolean isStatusCodeOk(int responseCode) {
        if (this.minOkRange > 0) {
            return responseCode >= this.minOkRange && responseCode <= this.maxOkRange;
        }
        return HttpHelper.isStatusCodeOk((int)responseCode, (String)this.configuration.getOkStatusCodeRange());
    }

    private void configureProxyOptionsIfRequired(WebClientOptions options) {
        if (this.isProxyConfigurationPresent()) {
            ProxyOptions proxyOptions = new ProxyOptions();
            if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost())) {
                proxyOptions.setHost(this.configuration.getProxyHost());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
                proxyOptions.setPort(this.configuration.getProxyPort().intValue());
            }
            if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyUsername())) {
                proxyOptions.setUsername(this.configuration.getProxyUsername());
            }
            if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyPassword())) {
                proxyOptions.setPassword(this.configuration.getProxyPassword());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyType())) {
                proxyOptions.setType(this.configuration.getProxyType());
            }
            options.setProxyOptions(proxyOptions);
        }
    }

    private boolean isProxyConfigurationPresent() {
        return ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) || ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort()) || ObjectHelper.isNotEmpty((String)this.configuration.getProxyUsername()) || ObjectHelper.isNotEmpty((String)this.configuration.getProxyPassword()) || ObjectHelper.isNotEmpty((Object)this.configuration.getProxyType());
    }
}

