/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka;

import java.util.function.Supplier;
import org.apache.camel.Message;
import org.apache.camel.component.vertx.kafka.configuration.VertxKafkaConfiguration;
import org.apache.camel.util.ObjectHelper;

public class VertxKafkaConfigurationOptionsProxy {
    private final VertxKafkaConfiguration configuration;

    public VertxKafkaConfigurationOptionsProxy(VertxKafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    public Integer getPartitionId(Message message) {
        return this.getOption(message, "CamelVertxKafkaPartitionId", this.configuration::getPartitionId, Integer.class);
    }

    public Object getMessageKey(Message message) {
        return this.getOption(message, "CamelVertxKafkaMessageKey", () -> null, Object.class);
    }

    public String getKeySerializer() {
        return this.configuration.getKeySerializer();
    }

    public String getValueSerializer() {
        return this.configuration.getValueSerializer();
    }

    public Object getOverrideTimestamp(Message message) {
        Object timestamp = this.getOption(message, "CamelVertxKafkaOverrideTimestamp", () -> null, Object.class);
        if (ObjectHelper.isNotEmpty((Object)timestamp)) {
            message.removeHeader("CamelVertxKafkaOverrideTimestamp");
        }
        return timestamp;
    }

    public String getTopic(Message message) {
        return this.getOption(message, "CamelVertxKafkaTopic", this.configuration::getTopic, String.class);
    }

    public String getOverrideTopic(Message message) {
        String topic = this.getOption(message, "CamelVertxKafkaOverrideTopic", () -> null, String.class);
        if (ObjectHelper.isNotEmpty((String)topic)) {
            message.removeHeader("CamelVertxKafkaOverrideTopic");
        }
        return topic;
    }

    public VertxKafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    private <R> R getOption(Message message, String headerName, Supplier<R> fallbackFn, Class<R> type) {
        return ObjectHelper.isEmpty((Object)message) || ObjectHelper.isEmpty(this.getObjectFromHeaders(message, headerName, type)) ? fallbackFn.get() : this.getObjectFromHeaders(message, headerName, type);
    }

    private <T> T getObjectFromHeaders(Message message, String headerName, Class<T> classType) {
        return (T)message.getHeader(headerName, classType);
    }
}

