/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka;

import org.apache.camel.spi.Metadata;

public final class VertxKafkaConstants {
    private static final String HEADER_PREFIX = "CamelVertxKafka";
    @Metadata(description="*Producer:* Explicitly specify the partition identifier, for example partition `0`. This will trigger the component to produce all the massages to the specified partition.\n*Consumer:* The partition identifier where the message were consumed from.", javaType="Integer")
    public static final String PARTITION_ID = "CamelVertxKafkaPartitionId";
    @Metadata(description="*Producer:* Explicitly specify the message key, if partition ID is not specified, this will trigger the messages to go into the same partition.\n*Consumer:* The message key.", javaType="String")
    public static final String MESSAGE_KEY = "CamelVertxKafkaMessageKey";
    @Metadata(description="*Producer:* Explicitly specify the topic to where produce the messages, this will be *preserved* in case of header aggregation.\n*Consumer:* The topic from where the message originated.", javaType="String")
    public static final String TOPIC = "CamelVertxKafkaTopic";
    @Metadata(label="producer", description="Produced record metadata.", javaType="List<RecordMetadata>")
    public static final String RECORD_METADATA = "CamelVertxKafkaRecordMetadata";
    @Metadata(label="consumer", description="The offset of the message in Kafka topic.", javaType="Long")
    public static final String OFFSET = "CamelVertxKafkaOffset";
    @Metadata(label="consumer", description="The record Kafka headers.", javaType="List<KafkaHeader>")
    public static final String HEADERS = "CamelVertxKafkaHeaders";
    @Metadata(label="consumer", description="The timestamp of this record.", javaType="Long")
    public static final String TIMESTAMP = "CamelVertxKafkaTimestamp";
    @Metadata(label="producer", description="The ProducerRecord also has an associated timestamp. If the user did provide a timestamp, the producer will stamp the  record with the provided timestamp and the header is not preserved.", javaType="Long")
    public static final String OVERRIDE_TIMESTAMP = "CamelVertxKafkaOverrideTimestamp";
    public static final String MANUAL_COMMIT = "CamelVertxKafkaManualCommit";
    @Metadata(label="producer", description="Explicitly specify the topic to where produce the messages, this will *not be preserved* in case of header aggregation and it will take *precedence* over `CamelVertxKafkaTopic`.", javaType="String")
    public static final String OVERRIDE_TOPIC = "CamelVertxKafkaOverrideTopic";

    private VertxKafkaConstants() {
    }
}

