/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.vertx.kafka.configuration.BaseVertxKafkaConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class VertxKafkaConfiguration
extends BaseVertxKafkaConfiguration
implements Cloneable {
    @UriParam(label="common")
    private Integer partitionId;
    @UriPath(label="common")
    @Metadata(required=true)
    private String topic;
    @UriParam(label="common")
    private String bootstrapServers;
    @UriParam(label="common", defaultValue="use_all_dns_ips", enums="default,use_all_dns_ips,resolve_canonical_bootstrap_servers_only")
    private String clientDnsLookup = "use_all_dns_ips";
    @UriParam(label="common", defaultValue="5m", javaType="java.time.Duration")
    private long metadataMaxAgeMs = 300000L;
    @UriParam(label="common")
    private String clientId;
    @UriParam(label="common", defaultValue="131072")
    private int sendBufferBytes = 131072;
    @UriParam(label="common", defaultValue="32768")
    private int receiveBufferBytes = 32768;
    @UriParam(label="common", defaultValue="50ms", javaType="java.time.Duration")
    private long reconnectBackoffMs = 50L;
    @UriParam(label="common", defaultValue="1s", javaType="java.time.Duration")
    private long reconnectBackoffMaxMs = 1000L;
    @UriParam(label="common", defaultValue="100ms", javaType="java.time.Duration")
    private long retryBackoffMs = 100L;
    @UriParam(label="common", defaultValue="30s", javaType="java.time.Duration")
    private long metricsSampleWindowMs = 30000L;
    @UriParam(label="common", defaultValue="2")
    private int metricsNumSamples = 2;
    @UriParam(label="common", defaultValue="INFO", enums="INFO,DEBUG,TRACE")
    private String metricsRecordingLevel = "INFO";
    @UriParam(label="common")
    private String metricReporters;
    @UriParam(label="common", defaultValue="30s", javaType="java.time.Duration")
    private int requestTimeoutMs = 30000;
    @UriParam(label="common", defaultValue="10s", javaType="java.time.Duration")
    private long socketConnectionSetupTimeoutMs = 10000L;
    @UriParam(label="common", defaultValue="30s", javaType="java.time.Duration")
    private long socketConnectionSetupTimeoutMaxMs = 30000L;
    @UriParam(label="common", defaultValue="9m", javaType="java.time.Duration")
    private long connectionsMaxIdleMs = 540000L;
    @UriParam(label="common")
    private String interceptorClasses;
    @UriParam(label="common,security")
    private String securityProviders;
    @UriParam(label="common,security", defaultValue="PLAINTEXT")
    private String securityProtocol = "PLAINTEXT";
    @UriParam(label="common,security", defaultValue="TLSv1.2")
    private String sslProtocol = "TLSv1.2";
    @UriParam(label="common,security")
    private String sslProvider;
    @UriParam(label="common,security")
    private String sslCipherSuites;
    @UriParam(label="common,security", defaultValue="TLSv1.2,TLSv1.3")
    private String sslEnabledProtocols = "TLSv1.2,TLSv1.3";
    @UriParam(label="common,security", defaultValue="JKS")
    private String sslKeystoreType = "JKS";
    @UriParam(label="common,security")
    private String sslKeystoreLocation;
    @UriParam(label="common,security")
    private String sslKeystorePassword;
    @UriParam(label="common,security")
    private String sslKeyPassword;
    @UriParam(label="common,security")
    private String sslKeystoreKey;
    @UriParam(label="common,security")
    private String sslKeystoreCertificateChain;
    @UriParam(label="common,security")
    private String sslTruststoreCertificates;
    @UriParam(label="common,security", defaultValue="JKS")
    private String sslTruststoreType = "JKS";
    @UriParam(label="common,security")
    private String sslTruststoreLocation;
    @UriParam(label="common,security")
    private String sslTruststorePassword;
    @UriParam(label="common,security", defaultValue="SunX509")
    private String sslKeymanagerAlgorithm = "SunX509";
    @UriParam(label="common,security", defaultValue="PKIX")
    private String sslTrustmanagerAlgorithm = "PKIX";
    @UriParam(label="common,security", defaultValue="https")
    private String sslEndpointIdentificationAlgorithm = "https";
    @UriParam(label="common,security")
    private String sslSecureRandomImplementation;
    @UriParam(label="common,security")
    private String sslEngineFactoryClass;
    @UriParam(label="common,security")
    private String saslKerberosServiceName;
    @UriParam(label="common,security", defaultValue="/usr/bin/kinit")
    private String saslKerberosKinitCmd = "/usr/bin/kinit";
    @UriParam(label="common,security", defaultValue="0.8")
    private double saslKerberosTicketRenewWindowFactor = 0.8;
    @UriParam(label="common,security", defaultValue="0.05")
    private double saslKerberosTicketRenewJitter = 0.05;
    @UriParam(label="common,security", defaultValue="60000")
    private long saslKerberosMinTimeBeforeRelogin = 60000L;
    @UriParam(label="common,security", defaultValue="0.8")
    private double saslLoginRefreshWindowFactor = 0.8;
    @UriParam(label="common,security", defaultValue="0.05")
    private double saslLoginRefreshWindowJitter = 0.05;
    @UriParam(label="common,security", defaultValue="60")
    private short saslLoginRefreshMinPeriodSeconds = (short)60;
    @UriParam(label="common,security", defaultValue="300")
    private short saslLoginRefreshBufferSeconds = (short)300;
    @UriParam(label="common,security", defaultValue="GSSAPI")
    private String saslMechanism = "GSSAPI";
    @UriParam(label="common,security")
    private String saslJaasConfig;
    @UriParam(label="common,security")
    private String saslClientCallbackHandlerClass;
    @UriParam(label="common,security")
    private String saslLoginCallbackHandlerClass;
    @UriParam(label="common,security")
    private String saslLoginClass;
    @UriParam(label="common", prefix="additionalProperties.", multiValue=true)
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @UriParam(label="consumer")
    private Long seekToOffset;
    @UriParam(label="consumer", enums="beginning,end")
    private String seekToPosition;
    @UriParam(label="consumer")
    private String groupId;
    @UriParam(label="consumer")
    private String groupInstanceId;
    @UriParam(label="consumer", defaultValue="10s", javaType="java.time.Duration")
    private int sessionTimeoutMs = 10000;
    @UriParam(label="consumer", defaultValue="3s", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 3000;
    @UriParam(label="consumer", defaultValue="org.apache.kafka.clients.consumer.RangeAssignor")
    private String partitionAssignmentStrategy = "org.apache.kafka.clients.consumer.RangeAssignor";
    @UriParam(label="consumer", defaultValue="true")
    private boolean enableAutoCommit = true;
    @UriParam(label="consumer", defaultValue="5s", javaType="java.time.Duration")
    private int autoCommitIntervalMs = 5000;
    @UriParam(label="consumer")
    private String clientRack;
    @UriParam(label="consumer", defaultValue="1048576")
    private int maxPartitionFetchBytes = 0x100000;
    @UriParam(label="consumer", defaultValue="1")
    private int fetchMinBytes = 1;
    @UriParam(label="consumer", defaultValue="52428800")
    private int fetchMaxBytes = 0x3200000;
    @UriParam(label="consumer", defaultValue="500ms", javaType="java.time.Duration")
    private int fetchMaxWaitMs = 500;
    @UriParam(label="consumer", defaultValue="latest", enums="latest,earliest,none")
    private String autoOffsetReset = "latest";
    @UriParam(label="consumer", defaultValue="true")
    private boolean checkCrcs = true;
    @UriParam(label="consumer", defaultValue="org.apache.kafka.common.serialization.StringDeserializer")
    private String keyDeserializer = "org.apache.kafka.common.serialization.StringDeserializer";
    @UriParam(label="consumer", defaultValue="org.apache.kafka.common.serialization.StringDeserializer")
    private String valueDeserializer = "org.apache.kafka.common.serialization.StringDeserializer";
    @UriParam(label="consumer", defaultValue="1m", javaType="java.time.Duration")
    private int defaultApiTimeoutMs = 60000;
    @UriParam(label="consumer", defaultValue="500")
    private int maxPollRecords = 500;
    @UriParam(label="consumer", defaultValue="5m", javaType="java.time.Duration")
    private int maxPollIntervalMs = 300000;
    @UriParam(label="consumer", defaultValue="true")
    private boolean excludeInternalTopics = true;
    @UriParam(label="consumer", defaultValue="read_uncommitted", enums="read_committed,read_uncommitted")
    private String isolationLevel = "read_uncommitted";
    @UriParam(label="consumer", defaultValue="true")
    private boolean allowAutoCreateTopics = true;
    @UriParam(label="producer", defaultValue="33554432")
    private long bufferMemory = 0x2000000L;
    @UriParam(label="producer", defaultValue="2147483647")
    private int retries = Integer.MAX_VALUE;
    @UriParam(label="producer", defaultValue="1", enums="all,-1,0,1")
    private String acks = "1";
    @UriParam(label="producer", defaultValue="none")
    private String compressionType = "none";
    @UriParam(label="producer", defaultValue="16384")
    private int batchSize = 16384;
    @UriParam(label="producer", defaultValue="0ms", javaType="java.time.Duration")
    private long lingerMs = 0L;
    @UriParam(label="producer", defaultValue="2m", javaType="java.time.Duration")
    private int deliveryTimeoutMs = 120000;
    @UriParam(label="producer", defaultValue="1048576")
    private int maxRequestSize = 0x100000;
    @UriParam(label="producer", defaultValue="1m", javaType="java.time.Duration")
    private long maxBlockMs = 60000L;
    @UriParam(label="producer", defaultValue="5m", javaType="java.time.Duration")
    private long metadataMaxIdleMs = 300000L;
    @UriParam(label="producer", defaultValue="5")
    private int maxInFlightRequestsPerConnection = 5;
    @UriParam(label="producer", defaultValue="org.apache.kafka.common.serialization.StringSerializer")
    private String keySerializer = "org.apache.kafka.common.serialization.StringSerializer";
    @UriParam(label="producer", defaultValue="org.apache.kafka.common.serialization.StringSerializer")
    private String valueSerializer = "org.apache.kafka.common.serialization.StringSerializer";
    @UriParam(label="producer", defaultValue="org.apache.kafka.clients.producer.internals.DefaultPartitioner")
    private String partitionerClass = "org.apache.kafka.clients.producer.internals.DefaultPartitioner";
    @UriParam(label="producer", defaultValue="false")
    private boolean enableIdempotence = false;
    @UriParam(label="producer", defaultValue="1m", javaType="java.time.Duration")
    private int transactionTimeoutMs = 60000;
    @UriParam(label="producer")
    private String transactionalId;

    public void setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
    }

    public Integer getPartitionId() {
        return this.partitionId;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setClientDnsLookup(String clientDnsLookup) {
        this.clientDnsLookup = clientDnsLookup;
    }

    public String getClientDnsLookup() {
        return this.clientDnsLookup;
    }

    public void setMetadataMaxAgeMs(long metadataMaxAgeMs) {
        this.metadataMaxAgeMs = metadataMaxAgeMs;
    }

    public long getMetadataMaxAgeMs() {
        return this.metadataMaxAgeMs;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setSendBufferBytes(int sendBufferBytes) {
        this.sendBufferBytes = sendBufferBytes;
    }

    public int getSendBufferBytes() {
        return this.sendBufferBytes;
    }

    public void setReceiveBufferBytes(int receiveBufferBytes) {
        this.receiveBufferBytes = receiveBufferBytes;
    }

    public int getReceiveBufferBytes() {
        return this.receiveBufferBytes;
    }

    public void setReconnectBackoffMs(long reconnectBackoffMs) {
        this.reconnectBackoffMs = reconnectBackoffMs;
    }

    public long getReconnectBackoffMs() {
        return this.reconnectBackoffMs;
    }

    public void setReconnectBackoffMaxMs(long reconnectBackoffMaxMs) {
        this.reconnectBackoffMaxMs = reconnectBackoffMaxMs;
    }

    public long getReconnectBackoffMaxMs() {
        return this.reconnectBackoffMaxMs;
    }

    public void setRetryBackoffMs(long retryBackoffMs) {
        this.retryBackoffMs = retryBackoffMs;
    }

    public long getRetryBackoffMs() {
        return this.retryBackoffMs;
    }

    public void setMetricsSampleWindowMs(long metricsSampleWindowMs) {
        this.metricsSampleWindowMs = metricsSampleWindowMs;
    }

    public long getMetricsSampleWindowMs() {
        return this.metricsSampleWindowMs;
    }

    public void setMetricsNumSamples(int metricsNumSamples) {
        this.metricsNumSamples = metricsNumSamples;
    }

    public int getMetricsNumSamples() {
        return this.metricsNumSamples;
    }

    public void setMetricsRecordingLevel(String metricsRecordingLevel) {
        this.metricsRecordingLevel = metricsRecordingLevel;
    }

    public String getMetricsRecordingLevel() {
        return this.metricsRecordingLevel;
    }

    public void setMetricReporters(String metricReporters) {
        this.metricReporters = metricReporters;
    }

    public String getMetricReporters() {
        return this.metricReporters;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setSocketConnectionSetupTimeoutMs(long socketConnectionSetupTimeoutMs) {
        this.socketConnectionSetupTimeoutMs = socketConnectionSetupTimeoutMs;
    }

    public long getSocketConnectionSetupTimeoutMs() {
        return this.socketConnectionSetupTimeoutMs;
    }

    public void setSocketConnectionSetupTimeoutMaxMs(long socketConnectionSetupTimeoutMaxMs) {
        this.socketConnectionSetupTimeoutMaxMs = socketConnectionSetupTimeoutMaxMs;
    }

    public long getSocketConnectionSetupTimeoutMaxMs() {
        return this.socketConnectionSetupTimeoutMaxMs;
    }

    public void setConnectionsMaxIdleMs(long connectionsMaxIdleMs) {
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
    }

    public long getConnectionsMaxIdleMs() {
        return this.connectionsMaxIdleMs;
    }

    public void setInterceptorClasses(String interceptorClasses) {
        this.interceptorClasses = interceptorClasses;
    }

    public String getInterceptorClasses() {
        return this.interceptorClasses;
    }

    public void setSecurityProviders(String securityProviders) {
        this.securityProviders = securityProviders;
    }

    public String getSecurityProviders() {
        return this.securityProviders;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    public String getSslProvider() {
        return this.sslProvider;
    }

    public void setSslCipherSuites(String sslCipherSuites) {
        this.sslCipherSuites = sslCipherSuites;
    }

    public String getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public void setSslEnabledProtocols(String sslEnabledProtocols) {
        this.sslEnabledProtocols = sslEnabledProtocols;
    }

    public String getSslEnabledProtocols() {
        return this.sslEnabledProtocols;
    }

    public void setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
    }

    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    public void setSslKeystoreLocation(String sslKeystoreLocation) {
        this.sslKeystoreLocation = sslKeystoreLocation;
    }

    public String getSslKeystoreLocation() {
        return this.sslKeystoreLocation;
    }

    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeystoreKey(String sslKeystoreKey) {
        this.sslKeystoreKey = sslKeystoreKey;
    }

    public String getSslKeystoreKey() {
        return this.sslKeystoreKey;
    }

    public void setSslKeystoreCertificateChain(String sslKeystoreCertificateChain) {
        this.sslKeystoreCertificateChain = sslKeystoreCertificateChain;
    }

    public String getSslKeystoreCertificateChain() {
        return this.sslKeystoreCertificateChain;
    }

    public void setSslTruststoreCertificates(String sslTruststoreCertificates) {
        this.sslTruststoreCertificates = sslTruststoreCertificates;
    }

    public String getSslTruststoreCertificates() {
        return this.sslTruststoreCertificates;
    }

    public void setSslTruststoreType(String sslTruststoreType) {
        this.sslTruststoreType = sslTruststoreType;
    }

    public String getSslTruststoreType() {
        return this.sslTruststoreType;
    }

    public void setSslTruststoreLocation(String sslTruststoreLocation) {
        this.sslTruststoreLocation = sslTruststoreLocation;
    }

    public String getSslTruststoreLocation() {
        return this.sslTruststoreLocation;
    }

    public void setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public void setSslKeymanagerAlgorithm(String sslKeymanagerAlgorithm) {
        this.sslKeymanagerAlgorithm = sslKeymanagerAlgorithm;
    }

    public String getSslKeymanagerAlgorithm() {
        return this.sslKeymanagerAlgorithm;
    }

    public void setSslTrustmanagerAlgorithm(String sslTrustmanagerAlgorithm) {
        this.sslTrustmanagerAlgorithm = sslTrustmanagerAlgorithm;
    }

    public String getSslTrustmanagerAlgorithm() {
        return this.sslTrustmanagerAlgorithm;
    }

    public void setSslEndpointIdentificationAlgorithm(String sslEndpointIdentificationAlgorithm) {
        this.sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm;
    }

    public String getSslEndpointIdentificationAlgorithm() {
        return this.sslEndpointIdentificationAlgorithm;
    }

    public void setSslSecureRandomImplementation(String sslSecureRandomImplementation) {
        this.sslSecureRandomImplementation = sslSecureRandomImplementation;
    }

    public String getSslSecureRandomImplementation() {
        return this.sslSecureRandomImplementation;
    }

    public void setSslEngineFactoryClass(String sslEngineFactoryClass) {
        this.sslEngineFactoryClass = sslEngineFactoryClass;
    }

    public String getSslEngineFactoryClass() {
        return this.sslEngineFactoryClass;
    }

    public void setSaslKerberosServiceName(String saslKerberosServiceName) {
        this.saslKerberosServiceName = saslKerberosServiceName;
    }

    public String getSaslKerberosServiceName() {
        return this.saslKerberosServiceName;
    }

    public void setSaslKerberosKinitCmd(String saslKerberosKinitCmd) {
        this.saslKerberosKinitCmd = saslKerberosKinitCmd;
    }

    public String getSaslKerberosKinitCmd() {
        return this.saslKerberosKinitCmd;
    }

    public void setSaslKerberosTicketRenewWindowFactor(double saslKerberosTicketRenewWindowFactor) {
        this.saslKerberosTicketRenewWindowFactor = saslKerberosTicketRenewWindowFactor;
    }

    public double getSaslKerberosTicketRenewWindowFactor() {
        return this.saslKerberosTicketRenewWindowFactor;
    }

    public void setSaslKerberosTicketRenewJitter(double saslKerberosTicketRenewJitter) {
        this.saslKerberosTicketRenewJitter = saslKerberosTicketRenewJitter;
    }

    public double getSaslKerberosTicketRenewJitter() {
        return this.saslKerberosTicketRenewJitter;
    }

    public void setSaslKerberosMinTimeBeforeRelogin(long saslKerberosMinTimeBeforeRelogin) {
        this.saslKerberosMinTimeBeforeRelogin = saslKerberosMinTimeBeforeRelogin;
    }

    public long getSaslKerberosMinTimeBeforeRelogin() {
        return this.saslKerberosMinTimeBeforeRelogin;
    }

    public void setSaslLoginRefreshWindowFactor(double saslLoginRefreshWindowFactor) {
        this.saslLoginRefreshWindowFactor = saslLoginRefreshWindowFactor;
    }

    public double getSaslLoginRefreshWindowFactor() {
        return this.saslLoginRefreshWindowFactor;
    }

    public void setSaslLoginRefreshWindowJitter(double saslLoginRefreshWindowJitter) {
        this.saslLoginRefreshWindowJitter = saslLoginRefreshWindowJitter;
    }

    public double getSaslLoginRefreshWindowJitter() {
        return this.saslLoginRefreshWindowJitter;
    }

    public void setSaslLoginRefreshMinPeriodSeconds(short saslLoginRefreshMinPeriodSeconds) {
        this.saslLoginRefreshMinPeriodSeconds = saslLoginRefreshMinPeriodSeconds;
    }

    public short getSaslLoginRefreshMinPeriodSeconds() {
        return this.saslLoginRefreshMinPeriodSeconds;
    }

    public void setSaslLoginRefreshBufferSeconds(short saslLoginRefreshBufferSeconds) {
        this.saslLoginRefreshBufferSeconds = saslLoginRefreshBufferSeconds;
    }

    public short getSaslLoginRefreshBufferSeconds() {
        return this.saslLoginRefreshBufferSeconds;
    }

    public void setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public void setSaslJaasConfig(String saslJaasConfig) {
        this.saslJaasConfig = saslJaasConfig;
    }

    public String getSaslJaasConfig() {
        return this.saslJaasConfig;
    }

    public void setSaslClientCallbackHandlerClass(String saslClientCallbackHandlerClass) {
        this.saslClientCallbackHandlerClass = saslClientCallbackHandlerClass;
    }

    public String getSaslClientCallbackHandlerClass() {
        return this.saslClientCallbackHandlerClass;
    }

    public void setSaslLoginCallbackHandlerClass(String saslLoginCallbackHandlerClass) {
        this.saslLoginCallbackHandlerClass = saslLoginCallbackHandlerClass;
    }

    public String getSaslLoginCallbackHandlerClass() {
        return this.saslLoginCallbackHandlerClass;
    }

    public void setSaslLoginClass(String saslLoginClass) {
        this.saslLoginClass = saslLoginClass;
    }

    public String getSaslLoginClass() {
        return this.saslLoginClass;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setSeekToOffset(Long seekToOffset) {
        this.seekToOffset = seekToOffset;
    }

    public Long getSeekToOffset() {
        return this.seekToOffset;
    }

    public void setSeekToPosition(String seekToPosition) {
        this.seekToPosition = seekToPosition;
    }

    public String getSeekToPosition() {
        return this.seekToPosition;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupInstanceId(String groupInstanceId) {
        this.groupInstanceId = groupInstanceId;
    }

    public String getGroupInstanceId() {
        return this.groupInstanceId;
    }

    public void setSessionTimeoutMs(int sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setPartitionAssignmentStrategy(String partitionAssignmentStrategy) {
        this.partitionAssignmentStrategy = partitionAssignmentStrategy;
    }

    public String getPartitionAssignmentStrategy() {
        return this.partitionAssignmentStrategy;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setAutoCommitIntervalMs(int autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
    }

    public int getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public void setClientRack(String clientRack) {
        this.clientRack = clientRack;
    }

    public String getClientRack() {
        return this.clientRack;
    }

    public void setMaxPartitionFetchBytes(int maxPartitionFetchBytes) {
        this.maxPartitionFetchBytes = maxPartitionFetchBytes;
    }

    public int getMaxPartitionFetchBytes() {
        return this.maxPartitionFetchBytes;
    }

    public void setFetchMinBytes(int fetchMinBytes) {
        this.fetchMinBytes = fetchMinBytes;
    }

    public int getFetchMinBytes() {
        return this.fetchMinBytes;
    }

    public void setFetchMaxBytes(int fetchMaxBytes) {
        this.fetchMaxBytes = fetchMaxBytes;
    }

    public int getFetchMaxBytes() {
        return this.fetchMaxBytes;
    }

    public void setFetchMaxWaitMs(int fetchMaxWaitMs) {
        this.fetchMaxWaitMs = fetchMaxWaitMs;
    }

    public int getFetchMaxWaitMs() {
        return this.fetchMaxWaitMs;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public void setCheckCrcs(boolean checkCrcs) {
        this.checkCrcs = checkCrcs;
    }

    public boolean isCheckCrcs() {
        return this.checkCrcs;
    }

    public void setKeyDeserializer(String keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
    }

    public String getKeyDeserializer() {
        return this.keyDeserializer;
    }

    public void setValueDeserializer(String valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
    }

    public String getValueDeserializer() {
        return this.valueDeserializer;
    }

    public void setDefaultApiTimeoutMs(int defaultApiTimeoutMs) {
        this.defaultApiTimeoutMs = defaultApiTimeoutMs;
    }

    public int getDefaultApiTimeoutMs() {
        return this.defaultApiTimeoutMs;
    }

    public void setMaxPollRecords(int maxPollRecords) {
        this.maxPollRecords = maxPollRecords;
    }

    public int getMaxPollRecords() {
        return this.maxPollRecords;
    }

    public void setMaxPollIntervalMs(int maxPollIntervalMs) {
        this.maxPollIntervalMs = maxPollIntervalMs;
    }

    public int getMaxPollIntervalMs() {
        return this.maxPollIntervalMs;
    }

    public void setExcludeInternalTopics(boolean excludeInternalTopics) {
        this.excludeInternalTopics = excludeInternalTopics;
    }

    public boolean isExcludeInternalTopics() {
        return this.excludeInternalTopics;
    }

    public void setIsolationLevel(String isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setAllowAutoCreateTopics(boolean allowAutoCreateTopics) {
        this.allowAutoCreateTopics = allowAutoCreateTopics;
    }

    public boolean isAllowAutoCreateTopics() {
        return this.allowAutoCreateTopics;
    }

    public void setBufferMemory(long bufferMemory) {
        this.bufferMemory = bufferMemory;
    }

    public long getBufferMemory() {
        return this.bufferMemory;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setAcks(String acks) {
        this.acks = acks;
    }

    public String getAcks() {
        return this.acks;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setLingerMs(long lingerMs) {
        this.lingerMs = lingerMs;
    }

    public long getLingerMs() {
        return this.lingerMs;
    }

    public void setDeliveryTimeoutMs(int deliveryTimeoutMs) {
        this.deliveryTimeoutMs = deliveryTimeoutMs;
    }

    public int getDeliveryTimeoutMs() {
        return this.deliveryTimeoutMs;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxBlockMs(long maxBlockMs) {
        this.maxBlockMs = maxBlockMs;
    }

    public long getMaxBlockMs() {
        return this.maxBlockMs;
    }

    public void setMetadataMaxIdleMs(long metadataMaxIdleMs) {
        this.metadataMaxIdleMs = metadataMaxIdleMs;
    }

    public long getMetadataMaxIdleMs() {
        return this.metadataMaxIdleMs;
    }

    public void setMaxInFlightRequestsPerConnection(int maxInFlightRequestsPerConnection) {
        this.maxInFlightRequestsPerConnection = maxInFlightRequestsPerConnection;
    }

    public int getMaxInFlightRequestsPerConnection() {
        return this.maxInFlightRequestsPerConnection;
    }

    public void setKeySerializer(String keySerializer) {
        this.keySerializer = keySerializer;
    }

    public String getKeySerializer() {
        return this.keySerializer;
    }

    public void setValueSerializer(String valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public String getValueSerializer() {
        return this.valueSerializer;
    }

    public void setPartitionerClass(String partitionerClass) {
        this.partitionerClass = partitionerClass;
    }

    public String getPartitionerClass() {
        return this.partitionerClass;
    }

    public void setEnableIdempotence(boolean enableIdempotence) {
        this.enableIdempotence = enableIdempotence;
    }

    public boolean isEnableIdempotence() {
        return this.enableIdempotence;
    }

    public void setTransactionTimeoutMs(int transactionTimeoutMs) {
        this.transactionTimeoutMs = transactionTimeoutMs;
    }

    public int getTransactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public void setTransactionalId(String transactionalId) {
        this.transactionalId = transactionalId;
    }

    public String getTransactionalId() {
        return this.transactionalId;
    }

    public Properties createConsumerConfiguration() {
        Properties props = new Properties();
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "partition.id", this.partitionId);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "topic", this.topic);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "bootstrap.servers", this.bootstrapServers);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "client.dns.lookup", this.clientDnsLookup);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metadata.max.age.ms", this.metadataMaxAgeMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "client.id", this.clientId);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "send.buffer.bytes", this.sendBufferBytes);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "receive.buffer.bytes", this.receiveBufferBytes);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.ms", this.reconnectBackoffMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.max.ms", this.reconnectBackoffMaxMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "retry.backoff.ms", this.retryBackoffMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metrics.sample.window.ms", this.metricsSampleWindowMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metrics.num.samples", this.metricsNumSamples);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metrics.recording.level", this.metricsRecordingLevel);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metric.reporters", this.metricReporters);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "request.timeout.ms", this.requestTimeoutMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "socket.connection.setup.timeout.ms", this.socketConnectionSetupTimeoutMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "socket.connection.setup.timeout.max.ms", this.socketConnectionSetupTimeoutMaxMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "connections.max.idle.ms", this.connectionsMaxIdleMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "interceptor.classes", this.interceptorClasses);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "security.providers", this.securityProviders);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "security.protocol", this.securityProtocol);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.protocol", this.sslProtocol);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.provider", this.sslProvider);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.cipher.suites", this.sslCipherSuites);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.enabled.protocols", this.sslEnabledProtocols);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.type", this.sslKeystoreType);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.location", this.sslKeystoreLocation);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.password", this.sslKeystorePassword);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.key.password", this.sslKeyPassword);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.key", this.sslKeystoreKey);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.certificate.chain", this.sslKeystoreCertificateChain);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.certificates", this.sslTruststoreCertificates);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.type", this.sslTruststoreType);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.location", this.sslTruststoreLocation);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.password", this.sslTruststorePassword);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keymanager.algorithm", this.sslKeymanagerAlgorithm);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.trustmanager.algorithm", this.sslTrustmanagerAlgorithm);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.endpoint.identification.algorithm", this.sslEndpointIdentificationAlgorithm);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.secure.random.implementation", this.sslSecureRandomImplementation);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.engine.factory.class", this.sslEngineFactoryClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.service.name", this.saslKerberosServiceName);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.kinit.cmd", this.saslKerberosKinitCmd);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.window.factor", this.saslKerberosTicketRenewWindowFactor);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.jitter", this.saslKerberosTicketRenewJitter);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.min.time.before.relogin", this.saslKerberosMinTimeBeforeRelogin);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.refresh.window.factor", this.saslLoginRefreshWindowFactor);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.refresh.window.jitter", this.saslLoginRefreshWindowJitter);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.refresh.min.period.seconds", this.saslLoginRefreshMinPeriodSeconds);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.refresh.buffer.seconds", this.saslLoginRefreshBufferSeconds);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.mechanism", this.saslMechanism);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.jaas.config", this.saslJaasConfig);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.client.callback.handler.class", this.saslClientCallbackHandlerClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.callback.handler.class", this.saslLoginCallbackHandlerClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.class", this.saslLoginClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "seek.to.offset", this.seekToOffset);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "seek.to.position", this.seekToPosition);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "group.id", this.groupId);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "group.instance.id", this.groupInstanceId);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "session.timeout.ms", this.sessionTimeoutMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "heartbeat.interval.ms", this.heartbeatIntervalMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "partition.assignment.strategy", this.partitionAssignmentStrategy);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "enable.auto.commit", this.enableAutoCommit);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "auto.commit.interval.ms", this.autoCommitIntervalMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "client.rack", this.clientRack);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "max.partition.fetch.bytes", this.maxPartitionFetchBytes);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "fetch.min.bytes", this.fetchMinBytes);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "fetch.max.bytes", this.fetchMaxBytes);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "fetch.max.wait.ms", this.fetchMaxWaitMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "auto.offset.reset", this.autoOffsetReset);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "check.crcs", this.checkCrcs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "key.deserializer", this.keyDeserializer);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "value.deserializer", this.valueDeserializer);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "default.api.timeout.ms", this.defaultApiTimeoutMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "max.poll.records", this.maxPollRecords);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "max.poll.interval.ms", this.maxPollIntervalMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "exclude.internal.topics", this.excludeInternalTopics);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "isolation.level", this.isolationLevel);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "allow.auto.create.topics", this.allowAutoCreateTopics);
        this.applyAdditionalProperties(props, this.getAdditionalProperties());
        return props;
    }

    public Properties createProducerConfiguration() {
        Properties props = new Properties();
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "partition.id", this.partitionId);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "topic", this.topic);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "bootstrap.servers", this.bootstrapServers);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "client.dns.lookup", this.clientDnsLookup);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metadata.max.age.ms", this.metadataMaxAgeMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "client.id", this.clientId);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "send.buffer.bytes", this.sendBufferBytes);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "receive.buffer.bytes", this.receiveBufferBytes);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.ms", this.reconnectBackoffMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "reconnect.backoff.max.ms", this.reconnectBackoffMaxMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "retry.backoff.ms", this.retryBackoffMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metrics.sample.window.ms", this.metricsSampleWindowMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metrics.num.samples", this.metricsNumSamples);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metrics.recording.level", this.metricsRecordingLevel);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metric.reporters", this.metricReporters);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "request.timeout.ms", this.requestTimeoutMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "socket.connection.setup.timeout.ms", this.socketConnectionSetupTimeoutMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "socket.connection.setup.timeout.max.ms", this.socketConnectionSetupTimeoutMaxMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "connections.max.idle.ms", this.connectionsMaxIdleMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "interceptor.classes", this.interceptorClasses);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "security.providers", this.securityProviders);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "security.protocol", this.securityProtocol);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.protocol", this.sslProtocol);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.provider", this.sslProvider);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.cipher.suites", this.sslCipherSuites);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.enabled.protocols", this.sslEnabledProtocols);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.type", this.sslKeystoreType);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.location", this.sslKeystoreLocation);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.password", this.sslKeystorePassword);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.key.password", this.sslKeyPassword);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.key", this.sslKeystoreKey);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keystore.certificate.chain", this.sslKeystoreCertificateChain);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.certificates", this.sslTruststoreCertificates);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.type", this.sslTruststoreType);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.location", this.sslTruststoreLocation);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.truststore.password", this.sslTruststorePassword);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.keymanager.algorithm", this.sslKeymanagerAlgorithm);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.trustmanager.algorithm", this.sslTrustmanagerAlgorithm);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.endpoint.identification.algorithm", this.sslEndpointIdentificationAlgorithm);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.secure.random.implementation", this.sslSecureRandomImplementation);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "ssl.engine.factory.class", this.sslEngineFactoryClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.service.name", this.saslKerberosServiceName);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.kinit.cmd", this.saslKerberosKinitCmd);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.window.factor", this.saslKerberosTicketRenewWindowFactor);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.ticket.renew.jitter", this.saslKerberosTicketRenewJitter);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.kerberos.min.time.before.relogin", this.saslKerberosMinTimeBeforeRelogin);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.refresh.window.factor", this.saslLoginRefreshWindowFactor);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.refresh.window.jitter", this.saslLoginRefreshWindowJitter);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.refresh.min.period.seconds", this.saslLoginRefreshMinPeriodSeconds);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.refresh.buffer.seconds", this.saslLoginRefreshBufferSeconds);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.mechanism", this.saslMechanism);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.jaas.config", this.saslJaasConfig);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.client.callback.handler.class", this.saslClientCallbackHandlerClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.callback.handler.class", this.saslLoginCallbackHandlerClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "sasl.login.class", this.saslLoginClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "buffer.memory", this.bufferMemory);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "retries", this.retries);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "acks", this.acks);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "compression.type", this.compressionType);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "batch.size", this.batchSize);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "linger.ms", this.lingerMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "delivery.timeout.ms", this.deliveryTimeoutMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "max.request.size", this.maxRequestSize);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "max.block.ms", this.maxBlockMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "metadata.max.idle.ms", this.metadataMaxIdleMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "max.in.flight.requests.per.connection", this.maxInFlightRequestsPerConnection);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "key.serializer", this.keySerializer);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "value.serializer", this.valueSerializer);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "partitioner.class", this.partitionerClass);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "enable.idempotence", this.enableIdempotence);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "transaction.timeout.ms", this.transactionTimeoutMs);
        VertxKafkaConfiguration.addPropertyIfNotNull(props, "transactional.id", this.transactionalId);
        this.applyAdditionalProperties(props, this.getAdditionalProperties());
        return props;
    }

    public VertxKafkaConfiguration copy() {
        try {
            return (VertxKafkaConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private void applyAdditionalProperties(Properties props, Map<String, Object> additionalProperties) {
        if (!ObjectHelper.isEmpty(this.getAdditionalProperties())) {
            additionalProperties.forEach((property, value) -> VertxKafkaConfiguration.addPropertyIfNotNull(props, property, value));
        }
    }

    private static <T> void addPropertyIfNotNull(Properties props, String key, T value) {
        if (value != null) {
            props.put(key, value.toString());
        }
    }
}

