/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.kafka.offset;

import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.KafkaConsumer;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.util.Collections;
import org.apache.camel.component.vertx.kafka.offset.VertxKafkaManualCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVertxKafkaManualCommit
implements VertxKafkaManualCommit {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultVertxKafkaManualCommit.class);
    private final KafkaConsumer<Object, Object> kafkaConsumer;
    private final String topicName;
    private final TopicPartition partition;
    private final long recordOffset;

    public DefaultVertxKafkaManualCommit(KafkaConsumer<Object, Object> kafkaConsumer, String topicName, TopicPartition partition, long recordOffset) {
        this.kafkaConsumer = kafkaConsumer;
        this.topicName = topicName;
        this.partition = partition;
        this.recordOffset = recordOffset;
    }

    @Override
    public void commit() {
        this.commitOffset(this.partition, this.recordOffset);
    }

    private void commitOffset(TopicPartition partition, long recordOffset) {
        if (recordOffset != -1L) {
            LOG.info("Commit offsets from topic {} with offset: {}", (Object)this.topicName, (Object)recordOffset);
            this.kafkaConsumer.commit(Collections.singletonMap(partition, new OffsetAndMetadata(recordOffset + 1L, "")));
        }
    }

    public KafkaConsumer<Object, Object> getKafkaConsumer() {
        return this.kafkaConsumer;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public TopicPartition getPartition() {
        return this.partition;
    }

    public long getRecordOffset() {
        return this.recordOffset;
    }
}

