/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.vertx.websocket.VertxWebsocketComponent;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxWebsocketConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(VertxWebsocketConsumer.class);
    private final VertxWebsocketEndpoint endpoint;

    public VertxWebsocketConsumer(VertxWebsocketEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.getComponent().connectConsumer(this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getComponent().disconnectConsumer(this);
        super.doStop();
    }

    public VertxWebsocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    public VertxWebsocketComponent getComponent() {
        return this.endpoint.getComponent();
    }

    public void onMessage(String connectionKey, Object message, SocketAddress remote, RoutingContext routingContext) {
        Exchange exchange = this.createExchange(true);
        exchange.getMessage().setHeader("CamelVertxWebsocket.remoteAddress", (Object)remote);
        exchange.getMessage().setHeader("CamelVertxWebsocket.connectionKey", (Object)connectionKey);
        exchange.getMessage().setBody(message);
        this.processExchange(exchange, routingContext);
    }

    public void onException(String connectionKey, Throwable cause, SocketAddress remote) {
        if (cause == ConnectionBase.CLOSED_EXCEPTION) {
            return;
        }
        Exchange exchange = this.createExchange(false);
        exchange.getMessage().setHeader("CamelVertxWebsocket.remoteAddress", (Object)remote);
        exchange.getMessage().setHeader("CamelVertxWebsocket.connectionKey", (Object)connectionKey);
        this.getExceptionHandler().handleException("Error processing exchange", exchange, cause);
        this.releaseExchange(exchange, false);
    }

    protected void processExchange(Exchange exchange, RoutingContext routingContext) {
        routingContext.vertx().executeBlocking(promise -> {
            try {
                this.createUoW(exchange);
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
                return;
            }
            this.getAsyncProcessor().process(exchange, c -> promise.complete());
        }, false, result -> {
            try {
                if (result.failed()) {
                    Throwable cause = result.cause();
                    this.getExceptionHandler().handleException(cause);
                    routingContext.fail(cause);
                }
            }
            finally {
                this.doneUoW(exchange);
                this.releaseExchange(exchange, false);
            }
        });
    }
}

