/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.vertx.websocket.VertxWebsocketComponent;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEndpoint;
import org.apache.camel.component.vertx.websocket.VertxWebsocketEvent;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHelper;
import org.apache.camel.support.DefaultConsumer;

public class VertxWebsocketConsumer
extends DefaultConsumer {
    private final VertxWebsocketEndpoint endpoint;

    public VertxWebsocketConsumer(VertxWebsocketEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.getComponent().connectConsumer(this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getComponent().disconnectConsumer(this);
        super.doStop();
    }

    public VertxWebsocketEndpoint getEndpoint() {
        return this.endpoint;
    }

    public VertxWebsocketComponent getComponent() {
        return this.endpoint.getComponent();
    }

    public void onMessage(String connectionKey, Object message, SocketAddress remote, RoutingContext routingContext) {
        Exchange exchange = this.createExchange(true);
        exchange.getMessage().setBody(message);
        this.populateExchangeHeaders(exchange, connectionKey, remote, routingContext, VertxWebsocketEvent.MESSAGE);
        this.processExchange(exchange, routingContext);
    }

    public void onException(String connectionKey, Throwable cause, SocketAddress remote, RoutingContext routingContext) {
        if (cause == ConnectionBase.CLOSED_EXCEPTION) {
            return;
        }
        Exchange exchange = this.createExchange(false);
        this.populateExchangeHeaders(exchange, connectionKey, remote, routingContext, VertxWebsocketEvent.ERROR);
        this.getExceptionHandler().handleException("Error processing exchange", exchange, cause);
        this.releaseExchange(exchange, false);
    }

    public void onOpen(String connectionKey, SocketAddress remote, RoutingContext routingContext, ServerWebSocket webSocket) {
        Exchange exchange = this.createExchange(true);
        this.populateExchangeHeaders(exchange, connectionKey, remote, routingContext, VertxWebsocketEvent.OPEN);
        exchange.getMessage().setBody((Object)webSocket);
        this.processExchange(exchange, routingContext);
    }

    public void onClose(String connectionKey, SocketAddress remote, RoutingContext routingContext) {
        Exchange exchange = this.createExchange(true);
        this.populateExchangeHeaders(exchange, connectionKey, remote, routingContext, VertxWebsocketEvent.CLOSE);
        this.processExchange(exchange, routingContext);
    }

    protected void populateExchangeHeaders(Exchange exchange, String connectionKey, SocketAddress remote, RoutingContext routingContext, VertxWebsocketEvent event) {
        Message message = exchange.getMessage();
        Map headers = message.getHeaders();
        message.setHeader("CamelVertxWebsocket.remoteAddress", (Object)remote);
        message.setHeader("CamelVertxWebsocket.connectionKey", (Object)connectionKey);
        message.setHeader("CamelVertxWebsocket.event", (Object)event);
        routingContext.queryParams().forEach((name, value) -> VertxWebsocketHelper.appendHeader(headers, name, value));
        routingContext.pathParams().forEach((name, value) -> VertxWebsocketHelper.appendHeader(headers, name, value));
    }

    protected void processExchange(Exchange exchange, RoutingContext routingContext) {
        routingContext.vertx().executeBlocking(() -> {
            this.createUoW(exchange);
            this.getProcessor().process(exchange);
            return null;
        }, false).onComplete(result -> {
            try {
                if (result.failed()) {
                    Throwable cause = result.cause();
                    this.getExceptionHandler().handleException(cause);
                    routingContext.fail(cause);
                }
            }
            finally {
                this.doneUoW(exchange);
                this.releaseExchange(exchange, false);
            }
        });
    }
}

