/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wal;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.wal.LogSupervisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogSupervisor
implements LogSupervisor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLogSupervisor.class);
    private long interval;
    private ScheduledExecutorService scheduledExecutorService;

    public DefaultLogSupervisor(long interval) {
        this(interval, Executors.newScheduledThreadPool(1));
    }

    public DefaultLogSupervisor(long interval, ScheduledExecutorService scheduledExecutorService) {
        this.interval = interval;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public void start(Runnable runnable) {
        this.scheduledExecutorService.scheduleAtFixedRate(runnable, 0L, this.interval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.scheduledExecutorService.shutdown();
        try {
            if (!this.scheduledExecutorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.scheduledExecutorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOG.error("Failed to shutdown log flusher: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

