/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelServerEndpoint
extends Endpoint {
    private final Logger log = LoggerFactory.getLogger(CamelServerEndpoint.class);
    private final Collection<BiConsumer<Session, Object>> endpoints = new CopyOnWriteArrayList<BiConsumer<Session, Object>>();
    private Session session;

    Collection<BiConsumer<Session, Object>> getEndpoints() {
        return this.endpoints;
    }

    Session getSession() {
        return this.session;
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.session = session;
        this.log.debug("Session opened #{}", (Object)session.getId());
        session.addMessageHandler(InputStream.class, this::propagateExchange);
        session.addMessageHandler(String.class, this::propagateExchange);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.log.debug("Session closed #{}", (Object)session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Session session, Throwable throwable) {
        Session session2 = session;
        synchronized (session2) {
            if (session.isOpen()) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, "an exception occured"));
                }
                catch (IOException e) {
                    this.log.debug("Error closing session #{}", (Object)session.getId(), (Object)e);
                }
            }
        }
        this.log.debug("Error on session #{}", (Object)session.getId(), (Object)throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateExchange(Object message) {
        Session session = this.session;
        synchronized (session) {
            this.endpoints.forEach(consumer -> consumer.accept(this.session, message));
        }
    }
}

