/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.net.URI;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.websocket.jsr356.CamelServerEndpoint;
import org.apache.camel.websocket.jsr356.ClientSessions;
import org.apache.camel.websocket.jsr356.JSR356Endpoint;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;
import org.apache.camel.websocket.jsr356.ServerEndpointDeploymentStrategy;

public class JSR356Consumer
extends DefaultConsumer {
    private ClientSessions manager;
    private Runnable closeTask;
    private final BiConsumer<Session, Object> onMessage = (session, message) -> {
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setHeader("jsr356.session", session);
        exchange.getIn().setBody(message);
        AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
        this.getAsyncProcessor().process(exchange, cb);
    };

    JSR356Consumer(JSR356Endpoint jsr356Endpoint, Processor processor) {
        super((Endpoint)jsr356Endpoint, processor);
    }

    public JSR356Endpoint getEndpoint() {
        return (JSR356Endpoint)((Object)JSR356Endpoint.class.cast(super.getEndpoint()));
    }

    protected void doStart() throws Exception {
        super.doStart();
        URI uri = this.getEndpoint().getUri();
        if (uri.getScheme() != null && uri.getScheme().equals("ws")) {
            ClientEndpointConfig.Builder clientConfig = ClientEndpointConfig.Builder.create();
            this.manager = new ClientSessions(this.getEndpoint().getSessionCount(), uri, clientConfig.build(), this.onMessage);
            this.manager.prepare();
        } else {
            JSR356WebSocketComponent.ContextBag bag = JSR356WebSocketComponent.getContext(null);
            CamelServerEndpoint endpoint = bag.getEndpoints().get(uri.getPath());
            if (endpoint == null) {
                ServerEndpointConfig.Builder configBuilder = ServerEndpointConfig.Builder.create(CamelServerEndpoint.class, (String)uri.getPath());
                final CamelServerEndpoint serverEndpoint = new CamelServerEndpoint();
                bag.getEndpoints().put(uri.getPath(), serverEndpoint);
                this.closeTask = this.addObserver(serverEndpoint);
                configBuilder.configurator(new ServerEndpointConfig.Configurator(){

                    public <T> T getEndpointInstance(Class<T> clazz) {
                        return clazz.cast((Object)serverEndpoint);
                    }
                });
                ServerEndpointDeploymentStrategy strategy = this.getEndpoint().getComponent().getServerEndpointDeploymentStrategy();
                strategy.deploy(bag.getContainer(), configBuilder);
            } else {
                this.closeTask = this.addObserver(endpoint);
            }
        }
    }

    private Runnable addObserver(CamelServerEndpoint endpoint) {
        endpoint.getEndpoints().add(this.onMessage);
        return () -> endpoint.getEndpoints().remove(this.onMessage);
    }

    protected void doStop() throws Exception {
        Optional.ofNullable(this.manager).ifPresent(ClientSessions::close);
        Optional.ofNullable(this.closeTask).ifPresent(Runnable::run);
        super.doStop();
    }
}

