/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.api.service.impl;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import javax.ws.rs.core.MediaType;
import org.apache.camel.component.wordpress.api.auth.WordpressAuthentication;
import org.apache.camel.component.wordpress.api.service.WordpressService;
import org.apache.cxf.ext.logging.LoggingInInterceptor;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractWordpressServiceAdapter<A>
implements WordpressService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWordpressServiceAdapter.class);
    private A spi;
    private final String apiVersion;
    private WordpressAuthentication authentication;

    AbstractWordpressServiceAdapter(String wordpressUrl, String apiVersion) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)apiVersion));
        this.apiVersion = apiVersion;
        this.spi = JAXRSClientFactory.create((String)wordpressUrl, this.getSpiType(), Collections.singletonList(new JacksonJsonProvider()));
        WebClient.client(this.spi).type(MediaType.APPLICATION_JSON_TYPE);
        WebClient.client(this.spi).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        WebClient.getConfig(this.spi).getHttpConduit().getClient().setAutoRedirect(true);
        WebClient.getConfig(this.spi).getInInterceptors().add(new LoggingInInterceptor());
        WebClient.getConfig(this.spi).getOutInterceptors().add(new LoggingOutInterceptor());
        LOGGER.info("******* {} API initialized *********", (Object)this.spi.getClass().getSimpleName());
    }

    protected abstract Class<A> getSpiType();

    protected final A getSpi() {
        return this.spi;
    }

    protected final String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public final void setWordpressAuthentication(WordpressAuthentication authentication) {
        this.authentication = authentication;
        if (this.authentication != null) {
            this.authentication.configureAuthentication(this.spi);
        }
    }
}

