/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.consumer;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.component.wordpress.WordpressEndpoint;
import org.apache.camel.component.wordpress.api.WordpressServiceProvider;
import org.apache.camel.component.wordpress.api.model.Post;
import org.apache.camel.component.wordpress.api.model.PostSearchCriteria;
import org.apache.camel.component.wordpress.api.service.WordpressServicePosts;
import org.apache.camel.component.wordpress.consumer.AbstractWordpressConsumer;

public class WordpressPostConsumer
extends AbstractWordpressConsumer {
    private WordpressServicePosts servicePosts = WordpressServiceProvider.getInstance().getService(WordpressServicePosts.class);

    public WordpressPostConsumer(WordpressEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public WordpressPostConsumer(WordpressEndpoint endpoint, Processor processor, ScheduledExecutorService scheduledExecutorService) {
        super(endpoint, processor, scheduledExecutorService);
    }

    @Override
    protected int poll() throws Exception {
        if (this.getConfiguration().getId() == null) {
            return this.pollForPostList();
        }
        return this.pollForSingle();
    }

    private int pollForPostList() {
        List posts = this.servicePosts.list((PostSearchCriteria)this.getConfiguration().getSearchCriteria());
        posts.stream().forEach(p -> this.process(p));
        return posts.size();
    }

    private int pollForSingle() {
        Post post = (Post)this.servicePosts.retrieve(this.getConfiguration().getId());
        if (post == null) {
            return 0;
        }
        this.process(post);
        return 1;
    }
}

