/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.consumer;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.component.wordpress.WordpressEndpoint;
import org.apache.camel.component.wordpress.api.WordpressServiceProvider;
import org.apache.camel.component.wordpress.api.model.User;
import org.apache.camel.component.wordpress.api.model.UserSearchCriteria;
import org.apache.camel.component.wordpress.api.service.WordpressServiceUsers;
import org.apache.camel.component.wordpress.consumer.AbstractWordpressConsumer;

public class WordpressUserConsumer
extends AbstractWordpressConsumer {
    private WordpressServiceUsers serviceUsers = WordpressServiceProvider.getInstance().getService(WordpressServiceUsers.class);

    public WordpressUserConsumer(WordpressEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public WordpressUserConsumer(WordpressEndpoint endpoint, Processor processor, ScheduledExecutorService scheduledExecutorService) {
        super(endpoint, processor, scheduledExecutorService);
    }

    @Override
    protected int poll() throws Exception {
        if (this.getConfiguration().getId() == null) {
            return this.pollForList();
        }
        return this.pollForSingle();
    }

    private int pollForSingle() {
        User user = (User)this.serviceUsers.retrieve(this.getConfiguration().getId());
        if (user == null) {
            return 0;
        }
        this.process(user);
        return 1;
    }

    private int pollForList() {
        List users = this.serviceUsers.list((UserSearchCriteria)this.getConfiguration().getSearchCriteria());
        users.stream().forEach(p -> this.process(p));
        LOG.trace("returned users is {}", users);
        return users.size();
    }
}

